/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.appcontent;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.appcontent.AppContentAction;
import com.google.android.gms.games.appcontent.AppContentActionEntity;
import com.google.android.gms.games.appcontent.AppContentAnnotation;
import com.google.android.gms.games.appcontent.AppContentAnnotationEntity;
import com.google.android.gms.games.appcontent.AppContentCard;
import com.google.android.gms.games.appcontent.AppContentCardEntity;
import com.google.android.gms.games.appcontent.AppContentSection;
import com.google.android.gms.games.appcontent.AppContentSectionEntityCreator;
import java.util.ArrayList;
import java.util.List;

public final class AppContentSectionEntity
implements SafeParcelable,
AppContentSection {
    public static final AppContentSectionEntityCreator CREATOR = new AppContentSectionEntityCreator();
    private final int mVersionCode;
    private final ArrayList<AppContentActionEntity> mActions;
    private final ArrayList<AppContentCardEntity> zzasx;
    private final String zzasf;
    private final Bundle mExtras;
    private final String zzasq;
    private final String zzagU;
    private final String zzFz;
    private final String zzwj;
    private final String zzasy;
    private final ArrayList<AppContentAnnotationEntity> zzaso;

    public AppContentSectionEntity(AppContentSection section) {
        this.mVersionCode = 5;
        this.zzasy = section.zztw();
        this.zzasf = section.zztb();
        this.mExtras = section.getExtras();
        this.zzwj = section.getId();
        this.zzasq = section.zztn();
        this.zzagU = section.getTitle();
        this.zzFz = section.getType();
        List<AppContentAction> list = section.getActions();
        int n = list.size();
        this.mActions = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.mActions.add((AppContentActionEntity)list.get(i).freeze());
        }
        List<AppContentCard> list2 = section.zztv();
        n = list2.size();
        this.zzasx = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzasx.add((AppContentCardEntity)list2.get(i).freeze());
        }
        List<AppContentAnnotation> list3 = section.zztl();
        n = list3.size();
        this.zzaso = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzaso.add((AppContentAnnotationEntity)list3.get(i).freeze());
        }
    }

    AppContentSectionEntity(int versionCode, ArrayList<AppContentActionEntity> actions, ArrayList<AppContentCardEntity> cards, String contentDescription, Bundle extras, String subtitle, String title, String type, String id, String cardType, ArrayList<AppContentAnnotationEntity> annotations) {
        this.mVersionCode = versionCode;
        this.mActions = actions;
        this.zzaso = annotations;
        this.zzasx = cards;
        this.zzasy = cardType;
        this.zzasf = contentDescription;
        this.mExtras = extras;
        this.zzwj = id;
        this.zzasq = subtitle;
        this.zzagU = title;
        this.zzFz = type;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public List<AppContentAction> getActions() {
        return new ArrayList<AppContentAction>(this.mActions);
    }

    @Override
    public List<AppContentAnnotation> zztl() {
        return new ArrayList<AppContentAnnotation>(this.zzaso);
    }

    @Override
    public List<AppContentCard> zztv() {
        return new ArrayList<AppContentCard>(this.zzasx);
    }

    @Override
    public String zztw() {
        return this.zzasy;
    }

    @Override
    public String zztb() {
        return this.zzasf;
    }

    @Override
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public String zztn() {
        return this.zzasq;
    }

    @Override
    public String getId() {
        return this.zzwj;
    }

    @Override
    public String getTitle() {
        return this.zzagU;
    }

    @Override
    public String getType() {
        return this.zzFz;
    }

    public AppContentSection zztx() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AppContentSectionEntity.zza(this);
    }

    static int zza(AppContentSection appContentSection) {
        return zzw.hashCode((Object[])new Object[]{appContentSection.getActions(), appContentSection.zztl(), appContentSection.zztv(), appContentSection.zztw(), appContentSection.zztb(), appContentSection.getExtras(), appContentSection.getId(), appContentSection.zztn(), appContentSection.getTitle(), appContentSection.getType()});
    }

    public boolean equals(Object obj) {
        return AppContentSectionEntity.zza(this, obj);
    }

    static boolean zza(AppContentSection appContentSection, Object object) {
        if (!(object instanceof AppContentSection)) {
            return false;
        }
        if (appContentSection == object) {
            return true;
        }
        AppContentSection appContentSection2 = (AppContentSection)object;
        return zzw.equal(appContentSection2.getActions(), appContentSection.getActions()) && zzw.equal(appContentSection2.zztl(), appContentSection.zztl()) && zzw.equal(appContentSection2.zztv(), appContentSection.zztv()) && zzw.equal((Object)appContentSection2.zztw(), (Object)appContentSection.zztw()) && zzw.equal((Object)appContentSection2.zztb(), (Object)appContentSection.zztb()) && zzw.equal((Object)appContentSection2.getExtras(), (Object)appContentSection.getExtras()) && zzw.equal((Object)appContentSection2.getId(), (Object)appContentSection.getId()) && zzw.equal((Object)appContentSection2.zztn(), (Object)appContentSection.zztn()) && zzw.equal((Object)appContentSection2.getTitle(), (Object)appContentSection.getTitle()) && zzw.equal((Object)appContentSection2.getType(), (Object)appContentSection.getType());
    }

    public String toString() {
        return AppContentSectionEntity.zzb(this);
    }

    static String zzb(AppContentSection appContentSection) {
        return zzw.zzu((Object)appContentSection).zzg("Actions", appContentSection.getActions()).zzg("Annotations", appContentSection.zztl()).zzg("Cards", appContentSection.zztv()).zzg("CardType", (Object)appContentSection.zztw()).zzg("ContentDescription", (Object)appContentSection.zztb()).zzg("Extras", (Object)appContentSection.getExtras()).zzg("Id", (Object)appContentSection.getId()).zzg("Subtitle", (Object)appContentSection.zztn()).zzg("Title", (Object)appContentSection.getTitle()).zzg("Type", (Object)appContentSection.getType()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        AppContentSectionEntityCreator.zza(this, out, flags);
    }

    public /* synthetic */ Object freeze() {
        return this.zztx();
    }
}

