/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntity;
import com.google.android.gms.games.quest.Quest;
import com.google.android.gms.games.quest.QuestEntityCreator;
import com.google.android.gms.internal.zzln;
import java.util.ArrayList;
import java.util.List;

public final class QuestEntity
implements SafeParcelable,
Quest {
    public static final Parcelable.Creator<QuestEntity> CREATOR = new QuestEntityCreator();
    private final int mVersionCode;
    private final GameEntity zzaxY;
    private final String zzayQ;
    private final long zzayR;
    private final Uri zzayS;
    private final String zzayT;
    private final String zzaoB;
    private final long zzayU;
    private final long zzasc;
    private final Uri zzayV;
    private final String zzayW;
    private final String mName;
    private final long zzayX;
    private final long zzayY;
    private final int mState;
    private final int zzUS;
    private final ArrayList<MilestoneEntity> zzayZ;

    public QuestEntity(Quest quest) {
        this.mVersionCode = 2;
        this.zzaxY = new GameEntity(quest.getGame());
        this.zzayQ = quest.getQuestId();
        this.zzayR = quest.getAcceptedTimestamp();
        this.zzaoB = quest.getDescription();
        this.zzayS = quest.getBannerImageUri();
        this.zzayT = quest.getBannerImageUrl();
        this.zzayU = quest.getEndTimestamp();
        this.zzayV = quest.getIconImageUri();
        this.zzayW = quest.getIconImageUrl();
        this.zzasc = quest.getLastUpdatedTimestamp();
        this.mName = quest.getName();
        this.zzayX = quest.zzva();
        this.zzayY = quest.getStartTimestamp();
        this.mState = quest.getState();
        this.zzUS = quest.getType();
        List<Milestone> list = quest.zzuZ();
        int n = list.size();
        this.zzayZ = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzayZ.add((MilestoneEntity)list.get(i).freeze());
        }
    }

    QuestEntity(int versionCode, GameEntity game, String questId, long acceptedTimestamp, Uri bannerImageUri, String bannerImageUrl, String description, long endTimestamp, long lastUpdatedTimestamp, Uri iconImageUri, String iconImageUrl, String name, long notifyTimestamp, long startTimestamp, int state, int type, ArrayList<MilestoneEntity> milestones) {
        this.mVersionCode = versionCode;
        this.zzaxY = game;
        this.zzayQ = questId;
        this.zzayR = acceptedTimestamp;
        this.zzayS = bannerImageUri;
        this.zzayT = bannerImageUrl;
        this.zzaoB = description;
        this.zzayU = endTimestamp;
        this.zzasc = lastUpdatedTimestamp;
        this.zzayV = iconImageUri;
        this.zzayW = iconImageUrl;
        this.mName = name;
        this.zzayX = notifyTimestamp;
        this.zzayY = startTimestamp;
        this.mState = state;
        this.zzUS = type;
        this.zzayZ = milestones;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getQuestId() {
        return this.zzayQ;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzaoB;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzaoB, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        return this.zzayV;
    }

    @Override
    public String getIconImageUrl() {
        return this.zzayW;
    }

    @Override
    public Uri getBannerImageUri() {
        return this.zzayS;
    }

    @Override
    public String getBannerImageUrl() {
        return this.zzayT;
    }

    @Override
    public Milestone getCurrentMilestone() {
        return this.zzuZ().get(0);
    }

    @Override
    public List<Milestone> zzuZ() {
        return new ArrayList<Milestone>(this.zzayZ);
    }

    @Override
    public Game getGame() {
        return this.zzaxY;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getType() {
        return this.zzUS;
    }

    @Override
    public long getAcceptedTimestamp() {
        return this.zzayR;
    }

    @Override
    public long getEndTimestamp() {
        return this.zzayU;
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzasc;
    }

    @Override
    public long zzva() {
        return this.zzayX;
    }

    @Override
    public long getStartTimestamp() {
        return this.zzayY;
    }

    @Override
    public boolean isEndingSoon() {
        return this.zzayX <= System.currentTimeMillis() + 1800000L;
    }

    public Quest freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return QuestEntity.zza(this);
    }

    static int zza(Quest quest) {
        return zzw.hashCode((Object[])new Object[]{quest.getGame(), quest.getQuestId(), quest.getAcceptedTimestamp(), quest.getBannerImageUri(), quest.getDescription(), quest.getEndTimestamp(), quest.getIconImageUri(), quest.getLastUpdatedTimestamp(), quest.zzuZ(), quest.getName(), quest.zzva(), quest.getStartTimestamp(), quest.getState()});
    }

    public boolean equals(Object obj) {
        return QuestEntity.zza(this, obj);
    }

    static boolean zza(Quest quest, Object object) {
        if (!(object instanceof Quest)) {
            return false;
        }
        if (quest == object) {
            return true;
        }
        Quest quest2 = (Quest)object;
        return zzw.equal((Object)quest2.getGame(), (Object)quest.getGame()) && zzw.equal((Object)quest2.getQuestId(), (Object)quest.getQuestId()) && zzw.equal((Object)quest2.getAcceptedTimestamp(), (Object)quest.getAcceptedTimestamp()) && zzw.equal((Object)quest2.getBannerImageUri(), (Object)quest.getBannerImageUri()) && zzw.equal((Object)quest2.getDescription(), (Object)quest.getDescription()) && zzw.equal((Object)quest2.getEndTimestamp(), (Object)quest.getEndTimestamp()) && zzw.equal((Object)quest2.getIconImageUri(), (Object)quest.getIconImageUri()) && zzw.equal((Object)quest2.getLastUpdatedTimestamp(), (Object)quest.getLastUpdatedTimestamp()) && zzw.equal(quest2.zzuZ(), quest.zzuZ()) && zzw.equal((Object)quest2.getName(), (Object)quest.getName()) && zzw.equal((Object)quest2.zzva(), (Object)quest.zzva()) && zzw.equal((Object)quest2.getStartTimestamp(), (Object)quest.getStartTimestamp()) && zzw.equal((Object)quest2.getState(), (Object)quest.getState());
    }

    public String toString() {
        return QuestEntity.zzb(this);
    }

    static String zzb(Quest quest) {
        return zzw.zzu((Object)quest).zzg("Game", (Object)quest.getGame()).zzg("QuestId", (Object)quest.getQuestId()).zzg("AcceptedTimestamp", (Object)quest.getAcceptedTimestamp()).zzg("BannerImageUri", (Object)quest.getBannerImageUri()).zzg("BannerImageUrl", (Object)quest.getBannerImageUrl()).zzg("Description", (Object)quest.getDescription()).zzg("EndTimestamp", (Object)quest.getEndTimestamp()).zzg("IconImageUri", (Object)quest.getIconImageUri()).zzg("IconImageUrl", (Object)quest.getIconImageUrl()).zzg("LastUpdatedTimestamp", (Object)quest.getLastUpdatedTimestamp()).zzg("Milestones", quest.zzuZ()).zzg("Name", (Object)quest.getName()).zzg("NotifyTimestamp", (Object)quest.zzva()).zzg("StartTimestamp", (Object)quest.getStartTimestamp()).zzg("State", (Object)quest.getState()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        QuestEntityCreator.zza(this, out, flags);
    }
}

