/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer.realtime;

import android.database.CharArrayBuffer;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.games.multiplayer.realtime.Room;
import com.google.android.gms.games.multiplayer.realtime.RoomEntityCreator;
import com.google.android.gms.internal.zzln;
import java.util.ArrayList;

public final class RoomEntity
extends GamesDowngradeableSafeParcel
implements Room {
    public static final Parcelable.Creator<RoomEntity> CREATOR = new RoomEntityCreatorCompat();
    private final int mVersionCode;
    private final String zzatg;
    private final String zzayv;
    private final long zzaxZ;
    private final int zzayw;
    private final String zzaoB;
    private final int zzayd;
    private final Bundle zzayt;
    private final ArrayList<ParticipantEntity> zzayc;
    private final int zzayx;

    public RoomEntity(Room room) {
        this.mVersionCode = 2;
        this.zzatg = room.getRoomId();
        this.zzayv = room.getCreatorId();
        this.zzaxZ = room.getCreationTimestamp();
        this.zzayw = room.getStatus();
        this.zzaoB = room.getDescription();
        this.zzayd = room.getVariant();
        this.zzayt = room.getAutoMatchCriteria();
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        this.zzayc = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.zzayc.add((ParticipantEntity)((Participant)arrayList.get(i)).freeze());
        }
        this.zzayx = room.getAutoMatchWaitEstimateSeconds();
    }

    RoomEntity(int versionCode, String roomId, String creatorId, long creationTimestamp, int roomStatus, String description, int variant, Bundle autoMatchCriteria, ArrayList<ParticipantEntity> participants, int autoMatchWaitEstimateSeconds) {
        this.mVersionCode = versionCode;
        this.zzatg = roomId;
        this.zzayv = creatorId;
        this.zzaxZ = creationTimestamp;
        this.zzayw = roomStatus;
        this.zzaoB = description;
        this.zzayd = variant;
        this.zzayt = autoMatchCriteria;
        this.zzayc = participants;
        this.zzayx = autoMatchWaitEstimateSeconds;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getRoomId() {
        return this.zzatg;
    }

    @Override
    public String getCreatorId() {
        return this.zzayv;
    }

    @Override
    public long getCreationTimestamp() {
        return this.zzaxZ;
    }

    @Override
    public int getStatus() {
        return this.zzayw;
    }

    @Override
    public String getDescription() {
        return this.zzaoB;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzaoB, (CharArrayBuffer)dataOut);
    }

    @Override
    public int getVariant() {
        return this.zzayd;
    }

    @Override
    public Bundle getAutoMatchCriteria() {
        return this.zzayt;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.zzayc);
    }

    @Override
    public int getAutoMatchWaitEstimateSeconds() {
        return this.zzayx;
    }

    @Override
    public int getParticipantStatus(String participantId) {
        return RoomEntity.zza((Room)this, participantId);
    }

    @Override
    public ArrayList<String> getParticipantIds() {
        return RoomEntity.zzc(this);
    }

    @Override
    public String getParticipantId(String playerId) {
        return RoomEntity.zzb(this, playerId);
    }

    @Override
    public Participant getParticipant(String participantId) {
        return RoomEntity.zzc(this, participantId);
    }

    public Room freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return RoomEntity.zza(this);
    }

    static int zza(Room room) {
        return zzw.hashCode((Object[])new Object[]{room.getRoomId(), room.getCreatorId(), room.getCreationTimestamp(), room.getStatus(), room.getDescription(), room.getVariant(), room.getAutoMatchCriteria(), room.getParticipants(), room.getAutoMatchWaitEstimateSeconds()});
    }

    public boolean equals(Object obj) {
        return RoomEntity.zza((Room)this, obj);
    }

    static boolean zza(Room room, Object object) {
        if (!(object instanceof Room)) {
            return false;
        }
        if (room == object) {
            return true;
        }
        Room room2 = (Room)object;
        return zzw.equal((Object)room2.getRoomId(), (Object)room.getRoomId()) && zzw.equal((Object)room2.getCreatorId(), (Object)room.getCreatorId()) && zzw.equal((Object)room2.getCreationTimestamp(), (Object)room.getCreationTimestamp()) && zzw.equal((Object)room2.getStatus(), (Object)room.getStatus()) && zzw.equal((Object)room2.getDescription(), (Object)room.getDescription()) && zzw.equal((Object)room2.getVariant(), (Object)room.getVariant()) && zzw.equal((Object)room2.getAutoMatchCriteria(), (Object)room.getAutoMatchCriteria()) && zzw.equal((Object)room2.getParticipants(), (Object)room.getParticipants()) && zzw.equal((Object)room2.getAutoMatchWaitEstimateSeconds(), (Object)room.getAutoMatchWaitEstimateSeconds());
    }

    public String toString() {
        return RoomEntity.zzb(this);
    }

    static String zzb(Room room) {
        return zzw.zzu((Object)room).zzg("RoomId", (Object)room.getRoomId()).zzg("CreatorId", (Object)room.getCreatorId()).zzg("CreationTimestamp", (Object)room.getCreationTimestamp()).zzg("RoomStatus", (Object)room.getStatus()).zzg("Description", (Object)room.getDescription()).zzg("Variant", (Object)room.getVariant()).zzg("AutoMatchCriteria", (Object)room.getAutoMatchCriteria()).zzg("Participants", (Object)room.getParticipants()).zzg("AutoMatchWaitEstimateSeconds", (Object)room.getAutoMatchWaitEstimateSeconds()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.zzos()) {
            RoomEntityCreator.zza(this, dest, flags);
        } else {
            dest.writeString(this.zzatg);
            dest.writeString(this.zzayv);
            dest.writeLong(this.zzaxZ);
            dest.writeInt(this.zzayw);
            dest.writeString(this.zzaoB);
            dest.writeInt(this.zzayd);
            dest.writeBundle(this.zzayt);
            int n = this.zzayc.size();
            dest.writeInt(n);
            for (int i = 0; i < n; ++i) {
                this.zzayc.get(i).writeToParcel(dest, flags);
            }
        }
    }

    static int zza(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant.getStatus();
        }
        throw new IllegalStateException("Participant " + string + " is not in room " + room.getRoomId());
    }

    static ArrayList<String> zzc(Room room) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            arrayList2.add(participant.getParticipantId());
        }
        return arrayList2;
    }

    static String zzb(Room room, String string) {
        String string2 = null;
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            Player player = participant.getPlayer();
            if (player == null || !player.getPlayerId().equals(string)) continue;
            string2 = participant.getParticipantId();
            break;
        }
        return string2;
    }

    static Participant zzc(Room room, String string) {
        ArrayList arrayList = room.getParticipants();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Participant participant = (Participant)arrayList.get(i);
            if (!participant.getParticipantId().equals(string)) continue;
            return participant;
        }
        throw new IllegalStateException("Participant " + string + " is not in match " + room.getRoomId());
    }

    static final class RoomEntityCreatorCompat
    extends RoomEntityCreator {
        RoomEntityCreatorCompat() {
        }

        @Override
        public RoomEntity zzdX(Parcel parcel) {
            int n;
            boolean bl = RoomEntity.zzd(RoomEntity.zzor());
            if (bl || RoomEntity.zzcj((String)RoomEntity.class.getCanonicalName())) {
                return super.zzdX(parcel);
            }
            String string = parcel.readString();
            String string2 = parcel.readString();
            long l = parcel.readLong();
            int n2 = parcel.readInt();
            String string3 = parcel.readString();
            int n3 = parcel.readInt();
            Bundle bundle = parcel.readBundle();
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n = 0; n < n4; ++n) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n = -1;
            return new RoomEntity(2, string, string2, l, n2, string3, n3, bundle, arrayList, n);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.zzdX(x0);
        }
    }
}

