/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.cast.ApplicationMetadata;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.internal.ApplicationStatus;
import com.google.android.gms.cast.internal.DeviceStatus;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.internal.zzi;
import com.google.android.gms.cast.internal.zzj;
import com.google.android.gms.cast.internal.zzl;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.zzj;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zze
extends zzj<zzi> {
    private static final zzl zzTy = new zzl("CastClientImpl");
    private ApplicationMetadata zzWN;
    private final CastDevice zzWO;
    private final Cast.Listener zzTk;
    private final Map<String, Cast.MessageReceivedCallback> zzWP;
    private final long zzWQ;
    private zzb zzWR;
    private String zzWS;
    private boolean zzUK;
    private boolean zzWT;
    private boolean zzWU;
    private boolean zzWV;
    private double zzUJ;
    private int zzWW;
    private int zzWX;
    private final AtomicLong zzWY;
    private String zzWZ;
    private String zzXa;
    private Bundle zzXb;
    private final Map<Long, zzc.zzb<Status>> zzXc;
    private zzc.zzb<Cast.ApplicationConnectionResult> zzXd;
    private zzc.zzb<Status> zzXe;
    private static final Object zzXf = new Object();
    private static final Object zzXg = new Object();

    public zze(Context context, Looper looper, com.google.android.gms.common.internal.zzf zzf2, CastDevice castDevice, long l, Cast.Listener listener, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 10, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.zzWO = castDevice;
        this.zzTk = listener;
        this.zzWQ = l;
        this.zzWP = new HashMap<String, Cast.MessageReceivedCallback>();
        this.zzWY = new AtomicLong(0L);
        this.zzXc = new HashMap<Long, zzc.zzb<Status>>();
        this.zzmv();
    }

    private void zzmv() {
        this.zzWV = false;
        this.zzWW = -1;
        this.zzWX = -1;
        this.zzWN = null;
        this.zzWS = null;
        this.zzUJ = 0.0;
        this.zzUK = false;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        zzTy.zzb("in onPostInitHandler; statusCode=%d", n);
        if (n == 0 || n == 1001) {
            this.zzWV = true;
            this.zzWT = true;
            this.zzWU = true;
        } else {
            this.zzWV = false;
        }
        int n3 = n;
        if (n == 1001) {
            this.zzXb = new Bundle();
            this.zzXb.putBoolean("com.google.android.gms.cast.EXTRA_APP_NO_LONGER_RUNNING", true);
            n3 = 0;
        }
        super.zza(n3, iBinder, bundle, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        zzTy.zzb("disconnect(); ServiceListener=%s, isConnected=%b", this.zzWR, this.isConnected());
        zzb zzb2 = this.zzWR;
        this.zzWR = null;
        if (zzb2 == null || zzb2.zzmG() == null) {
            zzTy.zzb("already disposed, so short-circuiting", new Object[0]);
            return;
        }
        this.zzmB();
        try {
            if (this.isConnected() || this.isConnecting()) {
                ((zzi)this.zzoA()).disconnect();
            }
        }
        catch (RemoteException remoteException) {
            zzTy.zzb(remoteException, "Error while disconnecting the controller interface: %s", remoteException.getMessage());
        }
        finally {
            super.disconnect();
        }
    }

    public Bundle zzmw() {
        if (this.zzXb != null) {
            Bundle bundle = this.zzXb;
            this.zzXb = null;
            return bundle;
        }
        return super.zzmw();
    }

    protected String zzfA() {
        return "com.google.android.gms.cast.service.BIND_CAST_DEVICE_CONTROLLER_SERVICE";
    }

    protected String zzfB() {
        return "com.google.android.gms.cast.internal.ICastDeviceController";
    }

    protected zzi zzaA(IBinder iBinder) {
        return zzi.zza.zzaB(iBinder);
    }

    protected Bundle zzli() {
        Bundle bundle = new Bundle();
        zzTy.zzb("getRemoteService(): mLastApplicationId=%s, mLastSessionId=%s", this.zzWZ, this.zzXa);
        this.zzWO.putInBundle(bundle);
        bundle.putLong("com.google.android.gms.cast.EXTRA_CAST_FLAGS", this.zzWQ);
        this.zzWR = new zzb(this);
        bundle.putParcelable("listener", (Parcelable)new BinderWrapper(this.zzWR.asBinder()));
        if (this.zzWZ != null) {
            bundle.putString("last_application_id", this.zzWZ);
            if (this.zzXa != null) {
                bundle.putString("last_session_id", this.zzXa);
            }
        }
        return bundle;
    }

    public void zza(String string2, String string3, zzc.zzb<Status> zzb2) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("The message payload cannot be null or empty");
        }
        if (string3.length() > 65536) {
            throw new IllegalArgumentException("Message exceeds maximum size");
        }
        zzf.zzbL(string2);
        this.zzmC();
        long l = this.zzWY.incrementAndGet();
        try {
            this.zzXc.put(l, zzb2);
            ((zzi)this.zzoA()).zza(string2, string3, l);
        }
        catch (Throwable throwable) {
            this.zzXc.remove(l);
            throw throwable;
        }
    }

    public void zza(String string2, boolean bl, zzc.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zzoA()).zzf(string2, bl);
    }

    public void zza(String string2, LaunchOptions launchOptions, zzc.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zzoA()).zza(string2, launchOptions);
    }

    public void zzb(String string2, String string3, zzc.zzb<Cast.ApplicationConnectionResult> zzb2) throws IllegalStateException, RemoteException {
        this.zzc(zzb2);
        ((zzi)this.zzoA()).zzt(string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzc(zzc.zzb<Cast.ApplicationConnectionResult> zzb2) {
        Object object = zzXf;
        synchronized (object) {
            if (this.zzXd != null) {
                this.zzXd.zzn((Object)new zza(new Status(2002)));
            }
            this.zzXd = zzb2;
        }
    }

    public void zzd(zzc.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zze(zzb2);
        ((zzi)this.zzoA()).zzmI();
    }

    public void zza(String string2, zzc.zzb<Status> zzb2) throws IllegalStateException, RemoteException {
        this.zze(zzb2);
        ((zzi)this.zzoA()).zzbO(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zze(zzc.zzb<Status> zzb2) {
        Object object = zzXg;
        synchronized (object) {
            if (this.zzXe != null) {
                zzb2.zzn((Object)new Status(2001));
                return;
            }
            this.zzXe = zzb2;
        }
    }

    public void zzmx() throws IllegalStateException, RemoteException {
        ((zzi)this.zzoA()).zzmx();
    }

    public void zze(double d) throws IllegalArgumentException, IllegalStateException, RemoteException {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Volume cannot be " + d);
        }
        ((zzi)this.zzoA()).zza(d, this.zzUJ, this.zzUK);
    }

    public void zzV(boolean bl) throws IllegalStateException, RemoteException {
        ((zzi)this.zzoA()).zza(bl, this.zzUJ, this.zzUK);
    }

    public double zzmy() throws IllegalStateException {
        this.zzmC();
        return this.zzUJ;
    }

    public boolean isMute() throws IllegalStateException {
        this.zzmC();
        return this.zzUK;
    }

    public int zzmz() throws IllegalStateException {
        this.zzmC();
        return this.zzWW;
    }

    public int zzmA() throws IllegalStateException {
        this.zzmC();
        return this.zzWX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(String string2, Cast.MessageReceivedCallback messageReceivedCallback) throws IllegalArgumentException, IllegalStateException, RemoteException {
        zzf.zzbL(string2);
        this.zzbK(string2);
        if (messageReceivedCallback != null) {
            Map<String, Cast.MessageReceivedCallback> map = this.zzWP;
            synchronized (map) {
                this.zzWP.put(string2, messageReceivedCallback);
            }
            ((zzi)this.zzoA()).zzbP(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbK(String string2) throws IllegalArgumentException, RemoteException {
        Cast.MessageReceivedCallback messageReceivedCallback;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Channel namespace cannot be null or empty");
        }
        Map<String, Cast.MessageReceivedCallback> map = this.zzWP;
        synchronized (map) {
            messageReceivedCallback = this.zzWP.remove(string2);
        }
        if (messageReceivedCallback != null) {
            try {
                ((zzi)this.zzoA()).zzbQ(string2);
            }
            catch (IllegalStateException illegalStateException) {
                zzTy.zzb(illegalStateException, "Error unregistering namespace (%s): %s", string2, illegalStateException.getMessage());
            }
        }
    }

    public ApplicationMetadata getApplicationMetadata() throws IllegalStateException {
        this.zzmC();
        return this.zzWN;
    }

    public String getApplicationStatus() throws IllegalStateException {
        this.zzmC();
        return this.zzWS;
    }

    public void onConnectionFailed(ConnectionResult result) {
        super.onConnectionFailed(result);
        this.zzmB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzmB() {
        zzTy.zzb("removing all MessageReceivedCallbacks", new Object[0]);
        Map<String, Cast.MessageReceivedCallback> map = this.zzWP;
        synchronized (map) {
            this.zzWP.clear();
        }
    }

    private void zza(DeviceStatus deviceStatus) {
        boolean bl;
        ApplicationMetadata applicationMetadata = deviceStatus.getApplicationMetadata();
        if (!zzf.zza(applicationMetadata, this.zzWN)) {
            this.zzWN = applicationMetadata;
            this.zzTk.onApplicationMetadataChanged(this.zzWN);
        }
        boolean bl2 = false;
        double d = deviceStatus.zzmy();
        if (d != Double.NaN && Math.abs(d - this.zzUJ) > 1.0E-7) {
            this.zzUJ = d;
            bl2 = true;
        }
        if ((bl = deviceStatus.zzmH()) != this.zzUK) {
            this.zzUK = bl;
            bl2 = true;
        }
        zzTy.zzb("hasVolumeChanged=%b, mFirstDeviceStatusUpdate=%b", bl2, this.zzWU);
        if (this.zzTk != null && (bl2 || this.zzWU)) {
            this.zzTk.onVolumeChanged();
        }
        boolean bl3 = false;
        int n = deviceStatus.zzmz();
        if (n != this.zzWW) {
            this.zzWW = n;
            bl3 = true;
        }
        zzTy.zzb("hasActiveInputChanged=%b, mFirstDeviceStatusUpdate=%b", bl3, this.zzWU);
        if (this.zzTk != null && (bl3 || this.zzWU)) {
            this.zzTk.onActiveInputStateChanged(this.zzWW);
        }
        boolean bl4 = false;
        int n2 = deviceStatus.zzmA();
        if (n2 != this.zzWX) {
            this.zzWX = n2;
            bl4 = true;
        }
        zzTy.zzb("hasStandbyStateChanged=%b, mFirstDeviceStatusUpdate=%b", bl4, this.zzWU);
        if (this.zzTk != null && (bl4 || this.zzWU)) {
            this.zzTk.onStandbyStateChanged(this.zzWX);
        }
        this.zzWU = false;
    }

    private void zza(ApplicationStatus applicationStatus) {
        boolean bl = false;
        String string2 = applicationStatus.zzms();
        if (!zzf.zza(string2, this.zzWS)) {
            this.zzWS = string2;
            bl = true;
        }
        zzTy.zzb("hasChanged=%b, mFirstApplicationStatusUpdate=%b", bl, this.zzWT);
        if (this.zzTk != null && (bl || this.zzWT)) {
            this.zzTk.onApplicationStatusChanged();
        }
        this.zzWT = false;
    }

    private void zzmC() throws IllegalStateException {
        if (!this.zzWV || this.zzWR == null || this.zzWR.isDisposed()) {
            throw new IllegalStateException("Not connected to a device");
        }
    }

    protected /* synthetic */ IInterface zzV(IBinder iBinder) {
        return this.zzaA(iBinder);
    }

    private static class zzb
    extends zzj.zza {
        private final AtomicReference<zze> zzXk;
        private final Handler mHandler;

        public zzb(zze zze2) {
            this.zzXk = new AtomicReference<zze>(zze2);
            this.mHandler = new Handler(zze2.getLooper());
        }

        public zze zzmG() {
            zze zze2 = this.zzXk.getAndSet(null);
            if (zze2 == null) {
                return null;
            }
            zze2.zzmv();
            return zze2;
        }

        public boolean isDisposed() {
            return this.zzXk.get() == null;
        }

        @Override
        public void zzaU(int n) {
            zze zze2 = this.zzmG();
            if (zze2 == null) {
                return;
            }
            zzTy.zzb("ICastDeviceControllerListener.onDisconnected: %d", n);
            if (n != 0) {
                zze2.zzbz(2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            zze zze2 = this.zzXk.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzWN = applicationMetadata;
            zze2.zzWZ = applicationMetadata.getApplicationId();
            zze2.zzXa = string3;
            Object object = zzXf;
            synchronized (object) {
                if (zze2.zzXd != null) {
                    zze2.zzXd.zzn((Object)new zza(new Status(0), applicationMetadata, string2, string3, bl));
                    zze2.zzXd = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzaV(int n) {
            zze zze2 = this.zzXk.get();
            if (zze2 == null) {
                return;
            }
            Object object = zzXf;
            synchronized (object) {
                if (zze2.zzXd != null) {
                    zze2.zzXd.zzn((Object)new zza(new Status(n)));
                    zze2.zzXd = null;
                }
            }
        }

        @Override
        public void zzaW(int n) {
            zze zze2 = this.zzXk.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void zzaX(int n) {
            zze zze2 = this.zzXk.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, n);
        }

        @Override
        public void onApplicationDisconnected(final int statusCode) {
            final zze zze2 = this.zzXk.get();
            if (zze2 == null) {
                return;
            }
            zze2.zzWZ = null;
            zze2.zzXa = null;
            this.zza(zze2, statusCode);
            if (zze2.zzTk != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (zze2.zzTk != null) {
                            zze2.zzTk.onApplicationDisconnected(statusCode);
                        }
                    }
                });
            }
        }

        @Override
        public void zza(String string2, double d, boolean bl) {
            zzTy.zzb("Deprecated callback: \"onStatusreceived\"", new Object[0]);
        }

        @Override
        public void zzb(final DeviceStatus deviceStatus) {
            final zze zze2 = this.zzXk.get();
            if (zze2 == null) {
                return;
            }
            zzTy.zzb("onDeviceStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(deviceStatus);
                }
            });
        }

        @Override
        public void zzb(final ApplicationStatus applicationStatus) {
            final zze zze2 = this.zzXk.get();
            if (zze2 == null) {
                return;
            }
            zzTy.zzb("onApplicationStatusChanged", new Object[0]);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    zze2.zza(applicationStatus);
                }
            });
        }

        @Override
        public void zzs(final String string2, final String string3) {
            final zze zze2 = this.zzXk.get();
            if (zze2 == null) {
                return;
            }
            zzTy.zzb("Receive (type=text, ns=%s) %s", string2, string3);
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Cast.MessageReceivedCallback messageReceivedCallback;
                    Map map = zze2.zzWP;
                    synchronized (map) {
                        messageReceivedCallback = (Cast.MessageReceivedCallback)zze2.zzWP.get(string2);
                    }
                    if (messageReceivedCallback != null) {
                        messageReceivedCallback.onMessageReceived(zze2.zzWO, string2, string3);
                    } else {
                        zzTy.zzb("Discarded message for unknown namespace '%s'", string2);
                    }
                }
            });
        }

        @Override
        public void zzb(String string2, byte[] byArray) {
            zze zze2 = this.zzXk.get();
            if (zze2 == null) {
                return;
            }
            zzTy.zzb("IGNORING: Receive (type=binary, ns=%s) <%d bytes>", string2, byArray.length);
        }

        @Override
        public void zza(String string2, long l, int n) {
            zze zze2 = this.zzXk.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, n);
        }

        @Override
        public void zzd(String string2, long l) {
            zze zze2 = this.zzXk.get();
            if (zze2 == null) {
                return;
            }
            this.zza(zze2, l, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void zza(zze zze2, long l, int n) {
            zzc.zzb zzb2;
            Map map = zze2.zzXc;
            synchronized (map) {
                zzb2 = (zzc.zzb)zze2.zzXc.remove(l);
            }
            if (zzb2 != null) {
                zzb2.zzn((Object)new Status(n));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean zza(zze zze2, int n) {
            Object object = zzXg;
            synchronized (object) {
                if (zze2.zzXe != null) {
                    zze2.zzXe.zzn((Object)new Status(n));
                    zze2.zzXe = null;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class zza
    implements Cast.ApplicationConnectionResult {
        private final Status zzQA;
        private final ApplicationMetadata zzXh;
        private final String zzXi;
        private final String zzGY;
        private final boolean zzXj;

        public zza(Status status, ApplicationMetadata applicationMetadata, String string2, String string3, boolean bl) {
            this.zzQA = status;
            this.zzXh = applicationMetadata;
            this.zzXi = string2;
            this.zzGY = string3;
            this.zzXj = bl;
        }

        public zza(Status status) {
            this(status, null, null, null, false);
        }

        public Status getStatus() {
            return this.zzQA;
        }

        @Override
        public ApplicationMetadata getApplicationMetadata() {
            return this.zzXh;
        }

        @Override
        public String getApplicationStatus() {
            return this.zzXi;
        }

        @Override
        public String getSessionId() {
            return this.zzGY;
        }

        @Override
        public boolean getWasLaunched() {
            return this.zzXj;
        }
    }
}

