/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.cast.zzb;
import com.google.android.gms.common.images.WebImage;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastDevice
implements SafeParcelable {
    public static final int CAPABILITY_VIDEO_OUT = 1;
    public static final int CAPABILITY_VIDEO_IN = 2;
    public static final int CAPABILITY_AUDIO_OUT = 4;
    public static final int CAPABILITY_AUDIO_IN = 8;
    public static final Parcelable.Creator<CastDevice> CREATOR = new zzb();
    private final int mVersionCode;
    private String zzTn;
    String zzTo;
    private Inet4Address zzTp;
    private String zzTq;
    private String zzTr;
    private String zzTs;
    private int zzTt;
    private List<WebImage> zzTu;
    private int zzTv;
    private int zzxJ;

    CastDevice(int versionCode, String deviceId, String hostAddress, String friendlyName, String modelName, String deviceVersion, int servicePort, List<WebImage> icons, int capabilities, int status) {
        this.mVersionCode = versionCode;
        this.zzTn = deviceId;
        this.zzTo = hostAddress;
        if (this.zzTo != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(this.zzTo);
                if (inetAddress instanceof Inet4Address) {
                    this.zzTp = (Inet4Address)inetAddress;
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.zzTp = null;
            }
        }
        this.zzTq = friendlyName;
        this.zzTr = modelName;
        this.zzTs = deviceVersion;
        this.zzTt = servicePort;
        this.zzTu = icons;
        this.zzTv = capabilities;
        this.zzxJ = status;
    }

    private CastDevice() {
        this(3, null, null, null, null, null, -1, new ArrayList<WebImage>(), 0, -1);
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getDeviceId() {
        return this.zzTn;
    }

    public Inet4Address getIpAddress() {
        return this.zzTp;
    }

    public String getFriendlyName() {
        return this.zzTq;
    }

    public String getModelName() {
        return this.zzTr;
    }

    public String getDeviceVersion() {
        return this.zzTs;
    }

    public int getServicePort() {
        return this.zzTt;
    }

    public List<WebImage> getIcons() {
        return Collections.unmodifiableList(this.zzTu);
    }

    public WebImage getIcon(int preferredWidth, int preferredHeight) {
        if (this.zzTu.isEmpty()) {
            return null;
        }
        if (preferredWidth <= 0 || preferredHeight <= 0) {
            return this.zzTu.get(0);
        }
        WebImage webImage = null;
        WebImage webImage2 = null;
        for (WebImage webImage3 : this.zzTu) {
            int n = webImage3.getWidth();
            int n2 = webImage3.getHeight();
            if (n >= preferredWidth && n2 >= preferredHeight) {
                if (webImage != null && (webImage.getWidth() <= n || webImage.getHeight() <= n2)) continue;
                webImage = webImage3;
                continue;
            }
            if (n >= preferredWidth || n2 >= preferredHeight || webImage2 != null && (webImage2.getWidth() >= n || webImage2.getHeight() >= n2)) continue;
            webImage2 = webImage3;
        }
        WebImage webImage4 = webImage != null ? webImage : (webImage2 != null ? webImage2 : this.zzTu.get(0));
        return webImage4;
    }

    public boolean hasIcons() {
        return !this.zzTu.isEmpty();
    }

    public int getCapabilities() {
        return this.zzTv;
    }

    public boolean hasCapability(int capability) {
        return (this.zzTv & capability) == capability;
    }

    public boolean hasCapabilities(int[] capabilities) {
        if (capabilities == null) {
            return false;
        }
        for (int n : capabilities) {
            if (this.hasCapability(n)) continue;
            return false;
        }
        return true;
    }

    public int getStatus() {
        return this.zzxJ;
    }

    public String toString() {
        return String.format("\"%s\" (%s)", this.zzTq, this.zzTn);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzb.zza(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CastDevice)) {
            return false;
        }
        CastDevice castDevice = (CastDevice)obj;
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return zzf.zza(this.zzTn, castDevice.zzTn) && zzf.zza(this.zzTp, castDevice.zzTp) && zzf.zza(this.zzTr, castDevice.zzTr) && zzf.zza(this.zzTq, castDevice.zzTq) && zzf.zza(this.zzTs, castDevice.zzTs) && this.zzTt == castDevice.zzTt && zzf.zza(this.zzTu, castDevice.zzTu) && this.zzTv == castDevice.zzTv && this.zzxJ == castDevice.zzxJ;
    }

    public boolean isSameDevice(CastDevice castDevice) {
        if (castDevice == null) {
            return false;
        }
        if (this.getDeviceId() == null) {
            return castDevice.getDeviceId() == null;
        }
        return zzf.zza(this.getDeviceId(), castDevice.getDeviceId());
    }

    public int hashCode() {
        return this.zzTn == null ? 0 : this.zzTn.hashCode();
    }

    public void putInBundle(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        bundle.putParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE", (Parcelable)this);
    }

    public static CastDevice getFromBundle(Bundle extras) {
        if (extras == null) {
            return null;
        }
        extras.setClassLoader(CastDevice.class.getClassLoader());
        return (CastDevice)extras.getParcelable("com.google.android.gms.cast.EXTRA_CAST_DEVICE");
    }

    public boolean isOnLocalNetwork() {
        return !this.zzTn.startsWith("__cast_nearby__");
    }
}

