/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.internal;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.internal.zzm;
import java.util.Locale;

public class ParcelableGeofence
implements SafeParcelable,
Geofence {
    private final int mVersionCode;
    private final String zzBm;
    private final long zzaDd;
    private final short zzaBC;
    private final double zzaBD;
    private final double zzaBE;
    private final float zzaBF;
    private final int zzaBA;
    private final int zzaBG;
    private final int zzaBH;
    public static final zzm CREATOR = new zzm();

    public ParcelableGeofence(int version, String requestId, int transitionTypes, short type, double latitude, double longitude, float radius, long expireAt, int notificationResponsiveness, int loiteringDelayMillis) {
        ParcelableGeofence.zzdy(requestId);
        ParcelableGeofence.zze(radius);
        ParcelableGeofence.zza(latitude, longitude);
        transitionTypes = ParcelableGeofence.zzgT(transitionTypes);
        this.mVersionCode = version;
        this.zzaBC = type;
        this.zzBm = requestId;
        this.zzaBD = latitude;
        this.zzaBE = longitude;
        this.zzaBF = radius;
        this.zzaDd = expireAt;
        this.zzaBA = transitionTypes;
        this.zzaBG = notificationResponsiveness;
        this.zzaBH = loiteringDelayMillis;
    }

    public ParcelableGeofence(String requestId, int transitionTypes, short type, double latitude, double longitude, float radius, long expireAt, int notificationResponsiveness, int loiteringDelayMillis) {
        this(1, requestId, transitionTypes, type, latitude, longitude, radius, expireAt, notificationResponsiveness, loiteringDelayMillis);
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public short zzvU() {
        return this.zzaBC;
    }

    public double getLatitude() {
        return this.zzaBD;
    }

    public double getLongitude() {
        return this.zzaBE;
    }

    public float zzvV() {
        return this.zzaBF;
    }

    @Override
    public String getRequestId() {
        return this.zzBm;
    }

    public long getExpirationTime() {
        return this.zzaDd;
    }

    public int zzvW() {
        return this.zzaBA;
    }

    public int getNotificationResponsiveness() {
        return this.zzaBG;
    }

    public int zzvX() {
        return this.zzaBH;
    }

    private static void zzdy(String string) {
        if (string == null || string.length() > 100) {
            throw new IllegalArgumentException("requestId is null or too long: " + string);
        }
    }

    private static void zze(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("invalid radius: " + f);
        }
    }

    private static void zza(double d, double d2) {
        if (d > 90.0 || d < -90.0) {
            throw new IllegalArgumentException("invalid latitude: " + d);
        }
        if (d2 > 180.0 || d2 < -180.0) {
            throw new IllegalArgumentException("invalid longitude: " + d2);
        }
    }

    private static int zzgT(int n) {
        int n2 = n & 7;
        if (n2 == 0) {
            throw new IllegalArgumentException("No supported transition specified: " + n);
        }
        return n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzm.zza(this, parcel, flags);
    }

    private static String zzgU(int n) {
        switch (n) {
            case 1: {
                return "CIRCLE";
            }
        }
        return null;
    }

    public static ParcelableGeofence zzn(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        ParcelableGeofence parcelableGeofence = CREATOR.zzey(parcel);
        parcel.recycle();
        return parcelableGeofence;
    }

    public String toString() {
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", ParcelableGeofence.zzgU(this.zzaBC), this.zzBm, this.zzaBA, this.zzaBD, this.zzaBE, Float.valueOf(this.zzaBF), this.zzaBG / 1000, this.zzaBH, this.zzaDd);
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = Double.doubleToLongBits(this.zzaBD);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzaBE);
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        n2 = 31 * n2 + Float.floatToIntBits(this.zzaBF);
        n2 = 31 * n2 + this.zzaBC;
        n2 = 31 * n2 + this.zzaBA;
        return n2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParcelableGeofence)) {
            return false;
        }
        ParcelableGeofence parcelableGeofence = (ParcelableGeofence)obj;
        if (this.zzaBF != parcelableGeofence.zzaBF) {
            return false;
        }
        if (this.zzaBD != parcelableGeofence.zzaBD) {
            return false;
        }
        if (this.zzaBE != parcelableGeofence.zzaBE) {
            return false;
        }
        return this.zzaBC == parcelableGeofence.zzaBC;
    }
}

