/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.content.Context;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.internal.zzrg;
import com.google.android.gms.internal.zzrh;
import com.google.android.gms.internal.zzrj;
import com.google.android.gms.internal.zzrk;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.NotifyTransactionStatusRequest;
import com.google.android.gms.wallet.Payments;
import com.google.android.gms.wallet.wobs.zzj;
import java.util.Locale;

public final class Wallet {
    private static final Api.zzc<zzrh> zzQf = new Api.zzc();
    private static final Api.zza<zzrh, WalletOptions> zzQg = new Api.zza<zzrh, WalletOptions>(){

        public zzrh zza(Context context, Looper looper, zzf zzf2, WalletOptions walletOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            WalletOptions walletOptions2 = walletOptions != null ? walletOptions : new WalletOptions();
            return new zzrh(context, looper, zzf2, connectionCallbacks, onConnectionFailedListener, walletOptions2.environment, walletOptions2.theme);
        }
    };
    public static final Api<WalletOptions> API = new Api("Wallet.API", zzQg, zzQf);
    public static final Payments Payments = new zzrg();
    public static final zzj zzaXC = new zzrk();
    public static final com.google.android.gms.wallet.firstparty.zza zzaXD = new zzrj();

    @Deprecated
    public static void checkForPreAuthorization(GoogleApiClient googleApiClient, int requestCode) {
        Payments.checkForPreAuthorization(googleApiClient, requestCode);
    }

    @Deprecated
    public static void loadMaskedWallet(GoogleApiClient googleApiClient, MaskedWalletRequest request, int requestCode) {
        Payments.loadMaskedWallet(googleApiClient, request, requestCode);
    }

    @Deprecated
    public static void loadFullWallet(GoogleApiClient googleApiClient, FullWalletRequest request, int requestCode) {
        Payments.loadFullWallet(googleApiClient, request, requestCode);
    }

    @Deprecated
    public static void changeMaskedWallet(GoogleApiClient googleApiClient, String googleTransactionId, String merchantTransactionId, int requestCode) {
        Payments.changeMaskedWallet(googleApiClient, googleTransactionId, merchantTransactionId, requestCode);
    }

    @Deprecated
    public static void notifyTransactionStatus(GoogleApiClient googleApiClient, NotifyTransactionStatusRequest request) {
        Payments.notifyTransactionStatus(googleApiClient, request);
    }

    private Wallet() {
    }

    public static abstract class zzb
    extends zza<Status> {
        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected Status zzd(Status status) {
            return status;
        }

        protected /* synthetic */ Result zzb(Status status) {
            return this.zzd(status);
        }
    }

    public static abstract class zza<R extends Result>
    extends zzc.zza<R, zzrh> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzQf, googleApiClient);
        }
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasOptions {
        public final int environment;
        public final int theme;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.zzaXE;
            this.theme = builder.mTheme;
        }

        public static final class Builder {
            private int zzaXE = 3;
            private int mTheme = 0;

            public Builder setEnvironment(int environment) {
                if (environment != 0 && environment != 2 && environment != 1 && environment != 3) {
                    String string = String.format(Locale.US, "Invalid environment value %d", environment);
                    throw new IllegalArgumentException(string);
                }
                this.zzaXE = environment;
                return this;
            }

            public Builder setTheme(int theme) {
                if (theme != 0 && theme != 1) {
                    String string = String.format(Locale.US, "Invalid theme value %d", theme);
                    throw new IllegalArgumentException(string);
                }
                this.mTheme = theme;
                return this;
            }

            public WalletOptions build() {
                return new WalletOptions(this);
            }
        }
    }
}

