/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.LongSparseArray;
import android.support.v4.util.Pools;
import android.support.v7.widget.RecyclerView;

class ViewInfoStore {
    private static final boolean DEBUG = false;
    final ArrayMap<RecyclerView.ViewHolder, InfoRecord> mLayoutHolderMap = new ArrayMap();
    final LongSparseArray<RecyclerView.ViewHolder> mOldChangedHolders = new LongSparseArray();

    ViewInfoStore() {
    }

    void clear() {
        this.mLayoutHolderMap.clear();
        this.mOldChangedHolders.clear();
    }

    void addToPreLayout(RecyclerView.ViewHolder holder, RecyclerView.ItemAnimator.ItemHolderInfo info) {
        InfoRecord record = (InfoRecord)this.mLayoutHolderMap.get((Object)holder);
        if (record == null) {
            record = InfoRecord.obtain();
            this.mLayoutHolderMap.put((Object)holder, (Object)record);
        }
        record.preInfo = info;
        record.flags |= 4;
    }

    @Nullable
    RecyclerView.ItemAnimator.ItemHolderInfo popFromPreLayout(RecyclerView.ViewHolder vh) {
        int index = this.mLayoutHolderMap.indexOfKey((Object)vh);
        if (index < 0) {
            return null;
        }
        InfoRecord record = (InfoRecord)this.mLayoutHolderMap.valueAt(index);
        if (record != null && (record.flags & 4) != 0) {
            record.flags &= 0xFFFFFFFB;
            RecyclerView.ItemAnimator.ItemHolderInfo info = record.preInfo;
            if (record.flags == 0) {
                this.mLayoutHolderMap.removeAt(index);
                InfoRecord.recycle(record);
            }
            return info;
        }
        return null;
    }

    void addToOldChangeHolders(long key, RecyclerView.ViewHolder holder) {
        this.mOldChangedHolders.put(key, (Object)holder);
    }

    void addToAppearedInPreLayoutHolders(RecyclerView.ViewHolder holder, RecyclerView.ItemAnimator.ItemHolderInfo info) {
        InfoRecord record = (InfoRecord)this.mLayoutHolderMap.get((Object)holder);
        if (record == null) {
            record = InfoRecord.obtain();
            this.mLayoutHolderMap.put((Object)holder, (Object)record);
        }
        record.flags |= 2;
        record.preInfo = info;
    }

    boolean isInPreLayout(RecyclerView.ViewHolder viewHolder) {
        InfoRecord record = (InfoRecord)this.mLayoutHolderMap.get((Object)viewHolder);
        return record != null && (record.flags & 4) != 0;
    }

    RecyclerView.ViewHolder getFromOldChangeHolders(long key) {
        return (RecyclerView.ViewHolder)this.mOldChangedHolders.get(key);
    }

    void addToPostLayout(RecyclerView.ViewHolder holder, RecyclerView.ItemAnimator.ItemHolderInfo info) {
        InfoRecord record = (InfoRecord)this.mLayoutHolderMap.get((Object)holder);
        if (record == null) {
            record = InfoRecord.obtain();
            this.mLayoutHolderMap.put((Object)holder, (Object)record);
        }
        record.postInfo = info;
        record.flags |= 8;
    }

    void addToDisappearedInLayout(RecyclerView.ViewHolder holder) {
        InfoRecord record = (InfoRecord)this.mLayoutHolderMap.get((Object)holder);
        if (record == null) {
            record = InfoRecord.obtain();
            this.mLayoutHolderMap.put((Object)holder, (Object)record);
        }
        record.flags |= 1;
    }

    void removeFromDisappearedInLayout(RecyclerView.ViewHolder holder) {
        InfoRecord record = (InfoRecord)this.mLayoutHolderMap.get((Object)holder);
        if (record == null) {
            return;
        }
        record.flags &= 0xFFFFFFFE;
    }

    void process(ProcessCallback callback) {
        for (int index = this.mLayoutHolderMap.size() - 1; index >= 0; --index) {
            RecyclerView.ViewHolder viewHolder = (RecyclerView.ViewHolder)this.mLayoutHolderMap.keyAt(index);
            InfoRecord record = (InfoRecord)this.mLayoutHolderMap.removeAt(index);
            if ((record.flags & 3) == 3) {
                callback.unused(viewHolder);
            } else if ((record.flags & 1) != 0) {
                callback.processDisappeared(viewHolder, record.preInfo, record.postInfo);
            } else if ((record.flags & 0xE) == 14) {
                callback.processAppeared(viewHolder, record.preInfo, record.postInfo);
            } else if ((record.flags & 0xC) == 12) {
                callback.processPersistent(viewHolder, record.preInfo, record.postInfo);
            } else if ((record.flags & 4) != 0) {
                callback.processDisappeared(viewHolder, record.preInfo, null);
            } else if ((record.flags & 8) != 0) {
                callback.processAppeared(viewHolder, record.preInfo, record.postInfo);
            } else if ((record.flags & 2) != 0) {
                // empty if block
            }
            InfoRecord.recycle(record);
        }
    }

    void removeViewHolder(RecyclerView.ViewHolder holder) {
        InfoRecord info;
        for (int i = this.mOldChangedHolders.size() - 1; i >= 0; --i) {
            if (holder != this.mOldChangedHolders.valueAt(i)) continue;
            this.mOldChangedHolders.removeAt(i);
            break;
        }
        if ((info = (InfoRecord)this.mLayoutHolderMap.remove((Object)holder)) != null) {
            InfoRecord.recycle(info);
        }
    }

    void onDetach() {
        InfoRecord.drainCache();
    }

    static class InfoRecord {
        static final int FLAG_DISAPPEARED = 1;
        static final int FLAG_APPEAR = 2;
        static final int FLAG_PRE = 4;
        static final int FLAG_POST = 8;
        static final int FLAG_APPEAR_AND_DISAPPEAR = 3;
        static final int FLAG_PRE_AND_POST = 12;
        static final int FLAG_APPEAR_PRE_AND_POST = 14;
        int flags;
        @Nullable
        RecyclerView.ItemAnimator.ItemHolderInfo preInfo;
        @Nullable
        RecyclerView.ItemAnimator.ItemHolderInfo postInfo;
        static Pools.Pool<InfoRecord> sPool = new Pools.SimplePool(20);

        private InfoRecord() {
        }

        static InfoRecord obtain() {
            InfoRecord record = (InfoRecord)sPool.acquire();
            return record == null ? new InfoRecord() : record;
        }

        static void recycle(InfoRecord record) {
            record.flags = 0;
            record.preInfo = null;
            record.postInfo = null;
            sPool.release((Object)record);
        }

        static void drainCache() {
            while (sPool.acquire() != null) {
            }
        }
    }

    static interface ProcessCallback {
        public void processDisappeared(RecyclerView.ViewHolder var1, RecyclerView.ItemAnimator.ItemHolderInfo var2, @Nullable RecyclerView.ItemAnimator.ItemHolderInfo var3);

        public void processAppeared(RecyclerView.ViewHolder var1, @Nullable RecyclerView.ItemAnimator.ItemHolderInfo var2, RecyclerView.ItemAnimator.ItemHolderInfo var3);

        public void processPersistent(RecyclerView.ViewHolder var1, @NonNull RecyclerView.ItemAnimator.ItemHolderInfo var2, @NonNull RecyclerView.ItemAnimator.ItemHolderInfo var3);

        public void unused(RecyclerView.ViewHolder var1);
    }
}

