package com.androidbook.livefolders;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.provider.BaseColumns;
import android.provider.ContactsContract;
import android.provider.LiveFolders;
import android.util.Log;

public class MyContactsProvider extends ContentProvider {

    public static final String AUTHORITY = "com.androidbook.livefolders.contacts";
   
    //Identyfikator Uri biorcy udzia w procesie tworzenia aktywnego folderu jako dane wejciowe
    public static final Uri CONTACTS_URI = Uri.parse("content://" +
            AUTHORITY + "/contacts"   );

    //Aby ten identyfikator URI zosta rozpoznany
    private static final int TYPE_MY_URI = 0;
    private static final UriMatcher URI_MATCHER;
    static{
      URI_MATCHER = new UriMatcher(UriMatcher.NO_MATCH);
      URI_MATCHER.addURI(AUTHORITY, "contacts", TYPE_MY_URI);
    }
    
    @Override
    public boolean onCreate() {
        return true;
    }

    @Override
    public int bulkInsert(Uri arg0, ContentValues[] values) {
      return 0; //niczego nie wstawiamy
    }

    //Zbir kolumn wymaganych przez aktywny folder
    //Jest to kontrakt aktywnego folderu
    private static final String[] CURSOR_COLUMNS = new String[]{
      BaseColumns._ID, 
      LiveFolders.NAME, 
      LiveFolders.DESCRIPTION, 
      LiveFolders.INTENT, 
      LiveFolders.ICON_PACKAGE, 
      LiveFolders.ICON_RESOURCE
    };
    
    //W przypadku braku krotek
    //wprowadzamy zastpstwo w postaci komunikatu o bdzie
    //Zauwamy, ze posiada taki sam zbir kolumn, jak aktywny folder
    private static final String[] CURSOR_ERROR_COLUMNS = new String[]{
      BaseColumns._ID, 
      LiveFolders.NAME, 
      LiveFolders.DESCRIPTION
    };
    
    
    //Krotka komunikatu o bdzie
    private static final Object[] ERROR_MESSAGE_ROW = 
         new Object[]
         {
          -1, //identyfikator
          "Nie znaleziono kontaktw", //nazwa 
          "Sprawd baz kontaktw" //opis
         };
    
    //Stosowany kursor bdu
    private static MatrixCursor sErrorCursor = new MatrixCursor(CURSOR_ERROR_COLUMNS);
    static {
      sErrorCursor.addRow(ERROR_MESSAGE_ROW);
    }

    //Kolumny odczytywane z bazy kontaktw
    private static final String[] CONTACTS_COLUMN_NAMES = new String[]{
      ContactsContract.Contacts._ID, 
      ContactsContract.Contacts.DISPLAY_NAME, 
      ContactsContract.Contacts.TIMES_CONTACTED, 
      ContactsContract.Contacts.STARRED
    };
    
    public Cursor query(Uri uri, String[] projection, String selection,
            String[] selectionArgs, String sortOrder) 
    {
    	//Sprawdza identyfikator uri i zwraca bd, jeeli nie znajdzie dopasowania
      int type = URI_MATCHER.match(uri);
      if(type == UriMatcher.NO_MATCH)
      {
        return sErrorCursor;
      }

      Log.i("ss", "kwerenda wywolana");
      
      try 
      {
       MatrixCursor mc = loadNewData(this);
        mc.setNotificationUri(getContext().getContentResolver(),  
              Uri.parse("content://contacts/people/"));
        MyCursor wmc = new MyCursor(mc,this);
        return wmc;
      } 
      catch (Throwable e) 
      {
        return sErrorCursor;
      }
    }
    
    public static MatrixCursor loadNewData(ContentProvider cp)
    {
       MatrixCursor mc = new MatrixCursor(CURSOR_COLUMNS);
        Cursor allContacts = null;
        try
        {
           allContacts = cp.getContext().getContentResolver().query(
              ContactsContract.Contacts.CONTENT_URI, 
              CONTACTS_COLUMN_NAMES, 
              null, //filtr krotek 
              null, 
              ContactsContract.Contacts.DISPLAY_NAME); //sortowanie
           
           while(allContacts.moveToNext())
           {
             String timesContacted = "Nawizane poczenia: "+allContacts.getInt(2);
             
             Object[] rowObject = new Object[]
             {
                 allContacts.getLong(0),    //identyfikator
                 allContacts.getString(1),    //nazwa
                 timesContacted,          //opis
                 Uri.parse("content://contacts/people/"+allContacts.getLong(0)), //intencja
                 cp.getContext().getPackageName(), //pakiet
                 R.drawable.icon   //ikona
             };
             mc.addRow(rowObject);
           }
          return mc;
        }
        finally
        {
           allContacts.close();
        }
        
    }
    
    
    @Override
    public String getType(Uri uri) 
    {
      //wskazuje typ MIME danego identyfikatora URI
      //zdefiniowanego dla osonowego dostawcy
      //Typ ten wyglda zazwyczaj nastpujco: 
      // "vnd.android.cursor.dir/vnd.google.note"
      return ContactsContract.Contacts.CONTENT_TYPE;
    }

    public Uri insert(Uri uri, ContentValues initialValues) {
      throw new UnsupportedOperationException(
            "nic nie zostaje wstawione, poniewa jest to wycznie osona");
    }
    
    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException(
        "nic nie zostaje usunite, poniewa jest to wycznie osona");
    }

    public int update(Uri uri, ContentValues values, 
            String selection, String[] selectionArgs) 
   {
        throw new UnsupportedOperationException(
        "nic nie zostaje zaktualizowane, poniewa jest to wycznie osona");
    }
}

