package com.androidbook.fragments.bard;

import android.app.Activity;
import android.app.ListFragment;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ListView;

public class TitlesFragment extends ListFragment {
    private MainActivity myActivity = null;
    int mCurCheckPosition = 0;

    @Override
    public void onInflate(AttributeSet attrs, Bundle icicle) {
    	Log.v(MainActivity.TAG,
    			"w metodzie onInflate klasy TitlesFragment. Obiekt AttributeSet zawiera:");
    	for(int i=0; i<attrs.getAttributeCount(); i++) {
            Log.v(MainActivity.TAG, "    " + attrs.getAttributeName(i) +
            		" = " + attrs.getAttributeValue(i));
    	}
    	super.onInflate(attrs, icicle);
/*    	
 *      Zwrmy uwag na defekt 14796. Metoda onInflate() zostaje wywoana po metodzie onCreateView()
 *      w momencie zmiany trybu wywietlania z krajobrazowego na portretowy. Jeeli sprbujemy
 *      zdefiniowa argumenty, zostanie wywietlony wyjtek IllegalStateException.
    	Bundle bundle = this.getArguments();
    	if(bundle == null) bundle = new Bundle();
    	bundle.putString("Dave", "Dave");
    	this.setArguments(bundle);
 */
    }

    @Override
    public void onAttach(Activity myActivity) {
    	Log.v(MainActivity.TAG, "w metodzie onAttach klasy TitlesFragment; aktywnosc: " + myActivity);
    	super.onAttach(myActivity);
    	this.myActivity = (MainActivity)myActivity;
    }

    @Override
    public void onCreate(Bundle icicle) {
    	Log.v(MainActivity.TAG, "w metodzie onCreate klasy TitlesFragment. Pakiet zawiera:");
    	if(icicle != null) {
            for(String key : icicle.keySet()) {
                Log.v(MainActivity.TAG, "    " + key);
            }
    	}
    	else {
            Log.v(MainActivity.TAG, "    Obiekt myBundle jest pusty");
    	}
    	super.onCreate(icicle);
        if (icicle != null) {
            // Odczytuje ostatni stan zaznaczonej pozycji.
            mCurCheckPosition = icicle.getInt("curChoice", 0);
        }
    }

    @Override
    public View onCreateView(LayoutInflater myInflater, ViewGroup container, Bundle icicle) {
    	Log.v(MainActivity.TAG, "w metodzie onCreateView klasy TitlesFragment. Pojemnikiem jest " + container);
    	return super.onCreateView(myInflater, container, icicle);
    }
    
    @Override
    public void onActivityCreated(Bundle icicle) {
    	Log.v(MainActivity.TAG, "w metodzie onActivityCreated klasy TitlesFragment. Ob. savedState zawiera:");
    	if(icicle != null) {
            for(String key : icicle.keySet()) {
                Log.v(MainActivity.TAG, "    " + key);
            }
    	}
    	else {
            Log.v(MainActivity.TAG, "    Obiekt savedState jest pusty");
    	}
        super.onActivityCreated(icicle);

        // Zapenia list tytuami pochodzcymi ze statycznej tabeli.
        setListAdapter(new ArrayAdapter<String>(getActivity(),
                android.R.layout.simple_list_item_1,
                Shakespeare.TITLES));

        ListView lv = getListView();
        lv.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
        lv.setSelection(mCurCheckPosition);

        myActivity.showDetails(mCurCheckPosition);
    }

    @Override
    public void onStart() {
    	Log.v(MainActivity.TAG, "w metodzie onStart klasy TitlesFragment");
    	super.onStart();
    }

    @Override
    public void onResume() {
    	Log.v(MainActivity.TAG, "w metodzie onResume klasy TitlesFragment");
    	super.onResume();
    }

    @Override
    public void onPause() {
    	Log.v(MainActivity.TAG, "w metodzie onPause klasy TitlesFragment");
    	super.onPause();
    }

    @Override
    public void onSaveInstanceState(Bundle icicle) {
    	Log.v(MainActivity.TAG, "w metodzie onSaveInstanceState klasy TitlesFragment");
        super.onSaveInstanceState(icicle);
        icicle.putInt("curChoice", mCurCheckPosition);
    }

    @Override
    public void onListItemClick(ListView l, View v, int pos, long id) {
    	Log.v(MainActivity.TAG, "w metodzie onListItemClick klasy TitlesFragment. pozycja = "
    			+ pos);
        myActivity.showDetails(pos);
    	mCurCheckPosition = pos;
    }

    @Override
    public void onStop() {
    	Log.v(MainActivity.TAG, "w metodzie onStop klasy TitlesFragment");
    	super.onStop();
    }

    @Override
    public void onDestroyView() {
    	Log.v(MainActivity.TAG, "w metodzie onDestroyView klasy TitlesFragment");
    	super.onDestroyView();
    }

    @Override
    public void onDestroy() {
    	Log.v(MainActivity.TAG, "w metodzie onDestroy klasy TitlesFragment");
    	super.onDestroy();
    }

    @Override
    public void onDetach() {
    	Log.v(MainActivity.TAG, "w metodzie onDetach klasy TitlesFragment");
    	super.onDetach();
    	myActivity = null;
    }
}
