package com.androidbook.preferences.sample;

// Jest to plik MainActivity.java
import android.app.Activity;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.util.Log;

public class MainActivity extends Activity {

    private static final String TAG = "SavingState";
	final String INITIALIZED = "zainicjowane";
	private String someString;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        SharedPreferences myPrefs = getPreferences(MODE_PRIVATE);

        boolean hasPreferences = myPrefs.getBoolean(INITIALIZED, false);

        if(hasPreferences) {
            Log.v(TAG, "Bylysmy wczesniej wywolywane");
            // Odczytuje w razie potrzeby inne wartoci z pliku preferencji
            someString = myPrefs.getString("someString", "");
        }
        else {
            Log.v(TAG, "Pierwszy raz wywolane");
            // Ustanawia pocztkowe wartoci dla danych,
            // ktre znajd si w pliku preferencji
            someString = "jaka domylna warto";
        }
        
        Log.v(TAG, "someString = " + someString);

        // Gdy wartoci bd ju gotowe do wypisania
        Editor editor = myPrefs.edit();
        editor.putBoolean(INITIALIZED, true);
        editor.putString("someString", someString);
        // W razie potrzeby zapisuje inne wartoci
        editor.commit();
    }
}