package com.ai.android.book.resources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.text.Spanned;

public class ResourceTester extends BaseTester 
{
	private static String tag = "ResourceTester";
	ResourceTester(Context ctx, IReportBack target)
	{
		super(ctx, target);
	}
	public void testEnStrings()
	{
		
		String msg = "dostpna we wszystkich katalogach en/us/root/port/en_port: test_en_us";
		reportString(msg, R.string.teststring_all);
		//Warto z pliku _port nie zostanie wybrana
		//Pierwszestwo uzyskuje konfiguracja en_us przed wersjami _port oraz en_port

		msg = "dostpna wycznie w katalogach root/en i port: t1_enport";
		reportString(msg, R.string.t1_enport);
		//Warto t1 znajduje si na tym samym poziomie, co en i port
		//Warto z pliku _port nie zostanie wybrana
		//Pierwszestwo zostaje przekazane plikowi zawartemu w katalogu en
		//Jeeli warto "t1" znajdzie si w konfiguracji values_en_port, zostanie wybrana wanie ona
		
		msg = "dostpna wycznie w katalogu root/en/port: t1_en_port";
		reportString(msg, R.string.t1_1_en_port);
		//Zostanie wybrana warto z katalogu _en_port
		//Warto z katalogu _port zostanie zignorowana
		//Warto z katalogu _en zostanie zignorowana
		
		msg = "dostpna jedynie w katalogu gwnym: t2";
		reportString(msg, R.string.t2);

		msg = "dostpna jedynie w katalogu port/root: testport_port";
		reportString(msg, R.string.testport_port);
		//Prezentujemy dowd,  e katalog _port rwnie jest brany pod uwag,
		//nawet w obecnoci innych katalogw posiadajcych
		//wyszy priorytet.
	}
	public void testStringArray()
	{
		reportArray(R.array.test_array);
	}
	public void testPlurals()
	{
		reportPlural(R.plurals.test_plurals,0);
		reportPlural(R.plurals.test_plurals,1);
		reportPlural(R.plurals.test_plurals,2);
		reportPlural(R.plurals.test_plurals,3);
	}
	private void reportPlural(int plural_id, int amount)
	{
		Resources res = this.mContext.getResources();
		String s = res.getQuantityString(plural_id, amount);
		this.mReportTo.reportBack(tag, s);
	}
	private void reportArray(int arrayId)
	{
		Resources res = this.mContext.getResources();
		String strings[] = res.getStringArray(arrayId);
		for (String s: strings)
		{
			this.mReportTo.reportBack(tag, s);
		}
	}
	public void testColor()
	{
		Resources res = this.mContext.getResources();
		int mainBackGroundColor 
	     =  res.getColor(R.color.main_back_ground_color);
		reportString("mainBackGroundColor:" + mainBackGroundColor);
	}
	public void testDimensions()
	{
		Resources res = this.mContext.getResources();
		reportString("wymiar:" + res.getDimension(R.dimen.medium_size));
		reportString("wymiar:" + res.getDimension(R.dimen.mysize_in_dp));
		reportString("wymiar:" + res.getDimension(R.dimen.mysize_in_pixels));
	}
	public void testStringVariations()
	{
		Context activity = this.mContext;
		//Odczytuje prosty cig znakw i wstawia go do widoku tekstu
		String simpleString = activity.getString(R.string.simple_string);
		reportString(simpleString);

		//Odczytuje cytowany cig znakw i wstawia go do widoku tekstu
		String quotedString = activity.getString(R.string.quoted_string);
		reportString(quotedString);

		//Odczytuje cig znakw w cudzysowie i wstawia go do widoku tekstu
		String doubleQuotedString = activity.getString(R.string.double_quoted_string);
		reportString(doubleQuotedString);

		//Odczytuje cig znakw sformatowany w jzyku Java
		String javaFormatString = activity.getString(R.string.java_format_string);
		//Konwertuje sformatowany cig znakw poprzez przeniesienie argumentw
		String substitutedString = String.format(javaFormatString, "Witaj" , "Androidzie");
		//Umieszcza dane wyjciowe w widoku tekstu
		reportString(substitutedString);

		// Odczytuje z zasobu cig znakw sformatowany w jzyku HTML i umieszcza go w widoku tekstu
		String htmlTaggedString = activity.getString(R.string.tagged_string);
		// Konwertuje go do postaci cigu tekstowego nadajcego si do umieszczenia w widoku
		// tekstu
		// Klasa android.text.Html umoliwia rysowanie cigw znakw w kodzie html
		// Jest to klasa cile zdefiniowana przez Android i nie obsuguje wszystkich znacznikw
		// html
		Spanned textSpan = android.text.Html.fromHtml(htmlTaggedString);
		// Umiemy to w widoku tekstu
		//this.getTextView().setText(textSpan);
		
	}
	private void report(int stringid)
	{
		this.mReportTo.reportBack(tag,this.mContext.getString(stringid));
	}
	private void reportString(String s)
	{
		this.mReportTo.reportBack(tag,s);
	}
	private void reportString(String s, int stringid)
	{
		this.mReportTo.reportBack(tag,s);
		report(stringid);
	}
	public void testXML()
	{
		try
		{
			String x = getEventsFromAnXMLFile(this.mContext);
			reportString(x); 
		}
		catch(Throwable t)
		{
			reportString("wystpi bd podczas odczytywania pliku xml:" + t.getMessage());
		}
		
	}
	private String getEventsFromAnXMLFile(Context activity)
	throws XmlPullParserException, IOException
	{
	   StringBuffer sb = new StringBuffer();
	   Resources res = activity.getResources();
	   XmlResourceParser xpp = res.getXml(R.xml.test);
	   
	   xpp.next();
	   int eventType = xpp.getEventType();
	    while (eventType != XmlPullParser.END_DOCUMENT) 
	    {
	        if(eventType == XmlPullParser.START_DOCUMENT) 
	        {
	           sb.append("******Pocztek dokumentu");
	        } 
	        else if(eventType == XmlPullParser.START_TAG) 
	        {
	           sb.append("\nPocztek znacznika "+xpp.getName());
	        } 
	        else if(eventType == XmlPullParser.END_TAG) 
	        {
	           sb.append("\nKoniec znacznika "+xpp.getName());
	        } 
	        else if(eventType == XmlPullParser.TEXT) 
	        {
	           sb.append("\nTekst "+xpp.getText());
	        }
	        eventType = xpp.next();
	    }//eof-while
	    sb.append("\n******Koniec dokumentu");
	    return sb.toString();
	}//eof-function
	
	public void testRawFile()
	{
		try
		{
			String s = getStringFromRawFile(this.mContext);
			this.reportString(s);
		}
		catch(Throwable t)
		{
			this.reportString("bd:" + t.getMessage());
		}
	}
	private String getStringFromRawFile(Context activity)
	   throws IOException
	   {
	      Resources r = activity.getResources();
	      InputStream is = r.openRawResource(R.raw.test);
	      String myText = convertStreamToString(is);
	      is.close();
	      return myText;
	   }

	   private String convertStreamToString(InputStream is)
	   throws IOException
	   {
	      ByteArrayOutputStream baos = new ByteArrayOutputStream();
	      int i = is.read();
	      while (i != -1)
	      {
	         baos.write(i);
	         i = is.read();
	      }
	      return baos.toString();
	   }
	   public void testAssets()
	   {
		   try
		   {
			   String s = getStringFromAssetFile(this.mContext);
			   reportString(s);
		   }
		   catch(Throwable t)
		   {
			   reportString("error:" + t.getMessage());
		   }
	   }
	   
	 //Uwaga: W tym kodzie wyjtki zostay pominite
	   String getStringFromAssetFile(Context activity)
	   throws IOException
	   {
	       AssetManager am = activity.getAssets();
	       InputStream is = am.open("test.txt");
	       String s = convertStreamToString(is);
	       is.close();
	       return s;
	   }
}
