package com.androidbook.fragments.bard;

import android.app.Activity;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;

public class DetailsActivity extends Activity {

    @Override
	public void onCreate(Bundle savedInstanceState) {
    	Log.v(MainActivity.TAG, "w metodzie onCreate klasy DetailsActivity");
        super.onCreate(savedInstanceState);

        if (getResources().getConfiguration().orientation
                == Configuration.ORIENTATION_LANDSCAPE) {
            // Jeeli ekran znajduje si w trybie krajobrazowyum, oznacza to,
            // e klasa MainActivity wywietla zarwno
            // tytuy oraz tekst, zatem niniejsza aktywno jest
            // ju niepotrzebna. Zignorujmy j i pozwlmy klasie MainActivity
            // zaj si wszystkimi zadaniami.
            finish();
            return;
        }

        if(getIntent() != null) {
        	// Jest to inny sposb utworzenia wystpienia fragmentu
            // przechowujcego szczegy. 
            DetailsFragment details =
        	    DetailsFragment.newInstance(getIntent().getExtras());

            getFragmentManager().beginTransaction()
                .add(android.R.id.content, details)
                .commit();
        }
    }
}
