package com.androidbook.maps.streetview;

// Jest to plik ClickReceiver.java
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.FloatMath;
import android.util.Log;
import android.view.MotionEvent;
import com.google.android.maps.GeoPoint;
import com.google.android.maps.MapView;
import com.google.android.maps.Overlay;

public class ClickReceiver extends Overlay {
	private static final String TAG = "ClickReceiver";
	private static final float ZOOMJUMP = 75f;
	private Context mContext;
	private boolean inZoomMode = false;
	private boolean ignoreLastFinger = false;
	private float mOrigSeparation;

	public ClickReceiver(Context context) {
        mContext = context;
	}

	@Override
	public boolean onTap(GeoPoint p, MapView mapView) {
		Log.v(TAG, "Otrzymano klikniecie w tym punkcie: " + p);
		
		if(mapView.isStreetView()) {
            Intent myIntent = new Intent(Intent.ACTION_VIEW, Uri.parse
    		    ("google.streetview:cbll=" +
    		    (float)p.getLatitudeE6() / 1000000f +
    		    "," + (float)p.getLongitudeE6() / 1000000f
    	        +"&cbp=1,180,,0,1.0"
                ));
		    mContext.startActivity(myIntent);
		    return true;
		}
	    return false;
	}
	
	public boolean onTouchEvent(MotionEvent e, MapView mapView) {
        Log.v(TAG, "w metodzie onTouchEvent, dzialaniem jest  " + e.getAction());
    	int action = e.getAction() & MotionEvent.ACTION_MASK;

    	if(e.getPointerCount() == 2) {
        	inZoomMode = true;
        }
        else {
        	inZoomMode = false;
        }
        
        if(inZoomMode) {
        	switch(action) {
        	case MotionEvent.ACTION_POINTER_DOWN:
        		// Moemy rozpocz nowy gest ciskania, wic przygotujmy si
        		mOrigSeparation = calculateSeparation(e);
        		break;
        	case MotionEvent.ACTION_POINTER_UP:
                // Koczymy gest ciskania, wic przygotujmy si
                // Ignoruje ostatni palec, gdy tylko on
                // dotyka wywietlacza.
        		ignoreLastFinger  = true;
        		break;
        	case MotionEvent.ACTION_MOVE:
                // Wykonujemy gest ciskania, wic decyduje
                // o zmianie poziomu przyblienia/oddalenia.
        		float newSeparation = calculateSeparation(e);
        		if(newSeparation - mOrigSeparation > ZOOMJUMP) {
        			// palce si rozeszy, przybliamy
        			mapView.getController().zoomIn();
        			mOrigSeparation = newSeparation;
        		}
        		else if (mOrigSeparation - newSeparation > ZOOMJUMP) {
        			// palce si zbliyy do siebie, oddalamy
        			mapView.getController().zoomOut();
        			mOrigSeparation = newSeparation;
        		}
        		break;
        	}
        	// Nie przekazujmy tych zdarze Androidowi, poniewa
            // zajmujemy si nimi.
        	return true;
        }
        else {
        	// W razie koniecznoci zeruje logik przybliania/oddalania.
        }

        // Jeeli tylko jeden palec jest przyoony, odrzucamy zdarzenia,
        // dopki nie zostanie uniesiony.
        if(ignoreLastFinger) {
            if(action == MotionEvent.ACTION_UP)
            	ignoreLastFinger = false;
        	return true;
        }

		return super.onTouchEvent(e, mapView);
	}

	private float calculateSeparation(MotionEvent e) {
		float x = e.getX(0) - e.getX(1);
		float y = e.getY(0) - e.getY(1);
		return FloatMath.sqrt(x * x + y * y);
	}
}
