package com.androidbook.salbcr;

import android.content.Context;
import android.os.PowerManager;
import android.util.Log;

public class GreenRoomOriginal 
{
	private static String tag="GreenRoom";
	private int count;
	private Context ctx = null;
	PowerManager.WakeLock wl = null;
	
	public GreenRoomOriginal(Context inCtx)
	{
		ctx = inCtx;
		wl = this.createWakeLock(inCtx);
	}
	synchronized public int enter()
	{
		count++;
		//kady obiekt odwiedzajcy, ktry wejdzie, zapala wiato.
		this.turnOnLights();
		Log.d(tag,"Wlaczanie swiatel: licznik:" + count);
		return count;
	}
	synchronized public void emptyTheRoom()
	{
		Log.d(tag, "Wywolanie powodujace wyczyszczenie pokoju");
		count = 0;
		this.turnOffLights();
	}
	synchronized public int leave()
	{
		if (count == 0) 
		{
			Log.w(tag,"Wartosc licznika wynosi 0.");
			return count;
		}
		count--;
		if (count == 0)
		{
			//Ostatni odwiedzajcy
			//gasi wiato
			turnOffLights();
		}
		return count;
	}
	
	synchronized public int getCount()
	{
		return count;
	}
	private void turnOnLights()
	{
		Log.d(tag, "Wlaczanie swiatel. Licznik:" + count);
		this.wl.acquire();
	}
	private void turnOffLights()
	{
		if (this.wl.isHeld())
		{
			Log.d(tag,"Zwalnianie blokady budzenia. Nie ma wiecej gosci.");
			this.wl.release();
		}
	}
	private PowerManager.WakeLock createWakeLock(Context inCtx)
	{
		PowerManager pm = 
			(PowerManager)inCtx.getSystemService(Context.POWER_SERVICE); 

		PowerManager.WakeLock wl = pm.newWakeLock
		     (PowerManager.PARTIAL_WAKE_LOCK, tag);
		return wl;
	}
	
	//*************************************************
	//*statyczni czonkowie: wymagani
	//*************************************************
	private static GreenRoomOriginal s_self = null;
	
	public static void setup(Context inCtx)
	{
		if (s_self == null)
		{
			Log.d(GreenRoomOriginal.tag,"Tworzenie zielonego pokoju");
			s_self = new GreenRoomOriginal(inCtx);
		}
	}
	/*
	 * Wywoywane przez metod "onstart" usugi
	 * w celu obsugi sytuacji, gdy usuga zostaje wybudzona
	 * z poprzedniego wywoania metody ondestroy
	 */
	public static boolean isSetup()
	{
		return (s_self != null) ? true: false; 
	}
	//*************************************************
	//*statyczni czonkowie: wycznie pomocnicze metody
	//*************************************************
	private static void assertSetup()
	{
		if (GreenRoomOriginal.s_self == null)
		{
			Log.w(GreenRoomOriginal.tag,"Musimy najpierw wywolac konfigurator");
			throw new RuntimeException("Musimy najpierw skonfiguorwa klas GreenRoom");
		}
	}
	public static int s_enter()
	{
		assertSetup();
		return s_self.enter();
	}
	public static int s_leave()
	{
		assertSetup();
		return s_self.leave();
	}
	public static void s_emptyTheRoom()
	{
		assertSetup();
		s_self.emptyTheRoom();
		return;
	}
}
