package com.ai.android.testmenus;

import android.app.Activity;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.widget.TextView;

public class SampleMenusActivity extends Activity {
	
	//Inicjujemy j w metodzie onCreateOptions
	Menu myMenu = null;
	
	/** Wywoywane podczas pierwszego utworzenia aktywnoci. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        //TextView tv = new TextView(this);
        //tv.setText("Witaj, Androidzie. Przywitaj si.");
        //setContentView(tv);
        
        setContentView(R.layout.main);
        
        //Przed wywoaniem tej metody upewnijmy si, e
        //ustawilimy widok treci
        registerForContextMenu(this.getTextView());
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) 
    {
    	//wywoujemy nadrzdny obiekt w celu doczenia menu systemowych
    	super.onCreateOptionsMenu(menu);
    	
    	this.myMenu = menu;
    	
    	//dodajemy kilka normalnych menu
    	addRegularMenuItems(menu);
    	
    	//dodajemy kilka menu drugorzdnych
    	add5SecondaryMenuItems(menu);
    	this.addSubMenu(menu);
    	
    	//aby menu byo wywietlane, musi zosta zwrcona warto true,
    	//w przeciwnym wypadku nie bdzie widoczne
    	return true;
    }
    
    private void addRegularMenuItems(Menu menu)
    {
    	//Drugorzdne elementy s wywietlane tak samo, jak pozostae
    	int base=Menu.FIRST; // warto wynosi 1

    	MenuItem item1 = menu.add(base,base,base,"dodaj");
    	menu.add(base,base+1,base+1,"element 2");
    	menu.add(base,base+2,base+2,"wyczy");
    	
    	menu.add(base,base+3,base+3,"ukryj drugorzdny");
    	menu.add(base,base+4,base+4,"poka drugorzdny");

    	menu.add(base,base+5,base+5,"wcz drugorzdny");
    	menu.add(base,base+6,base+6,"wycz drugorzdny");
    	
    	menu.add(base,base+7,base+7,"zaznacz drugorzdny");
    	MenuItem item8 = menu.add(base,base+8,base+8,"odznacz drugorzdny");

    	//Zostanie wywietlona ikona,
    	//ktra moe zasoni tekst
    	item1.setIcon(R.drawable.balloons);
    	
    	//Ale nie ta
    	item8.setIcon(R.drawable.balloons);
    }
    
    private void add5SecondaryMenuItems(Menu menu)
    {
    	//Drugorzdne elementy s wywietlane tak samo, jak pozostae
    	int base=Menu.CATEGORY_SECONDARY;

    	menu.add(base,base+1,base+1,"drug. element 1");
    	menu.add(base,base+2,base+2,"drug. element 2");
    	menu.add(base,base+3,base+3,"drug. element 3");
    	menu.add(base,base+3,base+3,"drug. element 4");
    	menu.add(base,base+4,base+4,"drug. element 5");
    }

    private void addSubMenu(Menu menu)
    {
    	//Drugorzdne elementy s wywietlane tak samo, jak pozostae
    	int base=Menu.FIRST + 100;
    	SubMenu sm = menu.addSubMenu(base,base+1,Menu.NONE,"podmenu");
    	MenuItem item1 = sm.add(base,base+2,base+2,"podelement1");
    	
    	sm.add(base,base+3,base+3, "podelement2");
    	sm.add(base,base+4,base+4, "podelement3");

    	//pracuje z ikonami
    	//ikony elementw podmenu nie s obsugiwane
    	item1.setIcon(R.drawable.icon48x48_2);
    	
    	//poniej widzimy poprawn skadni
    	sm.setIcon(R.drawable.icon48x48_1);
    	//Ponisza skadnia spowoduje wywietlenie wyjtku
    	//sm.addSubMenu("sprbuj tego");
    }
    
    @Override
    public boolean onOptionsItemSelected(MenuItem item) 
    {
    	if (item.getItemId() == 1)
    	{
        	appendText("\nwitaj");
    	}
    	else if (item.getItemId() == 2)
    	{
    		appendText("\nelement2");
    	}
    	else if (item.getItemId() == 3)
    	{
    		emptyText();
    	}
    	else if (item.getItemId() == 4)
    	{
    		//ukrywa drugorzdne
    		this.appendMenuItemText(item);
    		this.myMenu.setGroupVisible(Menu.CATEGORY_SECONDARY,false);
    	}
    	else if (item.getItemId() == 5)
    	{
    		//wywietla drugorzdne
    		this.appendMenuItemText(item);
    		this.myMenu.setGroupVisible(Menu.CATEGORY_SECONDARY,true);
    	}
    	else if (item.getItemId() == 6)
    	{
    		//uaktywnia drugorzdne
    		this.appendMenuItemText(item);
    		this.myMenu.setGroupEnabled(Menu.CATEGORY_SECONDARY,true);
    	}
    	else if (item.getItemId() == 7)
    	{
    		//wycza drugorzdne
    		this.appendMenuItemText(item);
    		this.myMenu.setGroupEnabled(Menu.CATEGORY_SECONDARY,false);
    	}
    	else if (item.getItemId() == 8)
    	{
    		//zaznacza drugorzdne
    		this.appendMenuItemText(item);
    		this.myMenu.setGroupCheckable(Menu.CATEGORY_SECONDARY,true,false);
    	}
    	else if (item.getItemId() == 9)
    	{
    		//odznacza drugorzdne
    		this.appendMenuItemText(item);
    		this.myMenu.setGroupCheckable(Menu.CATEGORY_SECONDARY,false,false);
    	}
    	else
    	{
    		this.appendMenuItemText(item);
    	}
    	//jeeli element menu jest przetwarzany,
    	//powinna zosta zwrcona warto true
    	return true;
    	
    	//Jeeli nie jest to element naszego menu,
    	//pozwlmy go przetwarza klasie bazowej
        //return super.onOptionsItemSelected(item);

    }
    
    //Obsuga menu kontekstowego
    @Override
    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo) {
        menu.setHeaderTitle("Przykadowe menu");
        menu.add(200, 200, 200, "element1");
    }
    
    @Override
    public boolean onContextItemSelected(MenuItem item) {
		this.appendMenuItemText(item);
		//alement menu zosta przetworzony
		return true;
    }
    //Ponisza metoda stanowi prezentacj funkcji wczytywania menu xml.
    //Moemy j wywoa z poziomu menu oncreateoptions w przypadku,
    //gdy wolimy stosowa wzy xml zamiast programowania menu
    //za pomoc kodu.
    private void loadXMLMenu(Menu menu)
    {
	   MenuInflater inflater = getMenuInflater(); //z aktywnoci
	   inflater.inflate(R.menu.my_menu, menu);
    }
    private TextView getTextView()
    {
       	TextView tv = 
       		(TextView)this.findViewById(R.id.textViewId);
       	return tv;
    }
    public void appendText(String text)
    {
       	TextView tv = 
       		(TextView)this.findViewById(R.id.textViewId);
       	tv.setText(tv.getText() + text);
    }
    private void appendMenuItemText(MenuItem menuItem)
    {
    	String title = menuItem.getTitle().toString();
       	TextView tv = 
       		(TextView)this.findViewById(R.id.textViewId);
       	tv.setText(tv.getText() + "\n" + title + ":" + menuItem.getItemId());
    }
    private void emptyText()
    {
       	TextView tv = 
       		(TextView)this.findViewById(R.id.textViewId);
       	tv.setText("");
    }
}//eof-class