package com.androidbook.fragments.bard;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;

public class MainActivity extends Activity {
    public static final String TAG = "Szekspir";

    @Override
    public void onCreate(Bundle savedInstanceState) {
		Log.v(TAG, "w metodzie onCreate aktywnosci MainActivity");
        super.onCreate(savedInstanceState);
		FragmentManager.enableDebugLogging(true);
        setContentView(R.layout.main);
    }

    @Override
    public void onAttachFragment(Fragment fragment) {
		Log.v(TAG, "w metodzie onAttachFragment aktywnosci MainActivity. Id fragmentu = "
				+ fragment.getId());
        super.onAttachFragment(fragment);
    }

    @Override
    public void onStart() {
		Log.v(TAG, "w metodzie onStart aktywnosci MainActivity");
    	super.onStart();
    }
    
    @Override
    public void onResume() {
		Log.v(TAG, "w metodzie onResume aktywnosci MainActivity");
    	super.onResume();
    }
    
    @Override
    public void onPause() {
		Log.v(TAG, "w metodzie onPause aktywnosci MainActivity");
    	super.onPause();
    }
    
    @Override
    public void onStop() {
		Log.v(TAG, "w metodzie onStop aktywnosci MainActivity");
    	super.onStop();
    }
    
    @Override
    public void onSaveInstanceState(Bundle outState) {
    	Log.v(MainActivity.TAG, "w metodzie onSaveInstanceState aktywnosci MainActivity");
        super.onSaveInstanceState(outState);
    }

    @Override
    public void onDestroy() {
		Log.v(TAG, "w metodzie onDestroy aktywnosci MainActivity");
    	super.onDestroy();
    }
    
    public boolean isMultiPane() {
        return getResources().getConfiguration().orientation
                == Configuration.ORIENTATION_LANDSCAPE;
    }

    /**
     * Funkcja pomocnicza ukazujca szczegy zaznaczonego elementu, albo poprzez
     * wywietlanie fragmentu znajdujcego si w biecym interfejsie uytkownika, albo
     * poprzez rozpoczcie nowej aktywnoci, w ktrej bd one wywietlane.
     */
    public void showDetails(int index) {
    	Log.v(TAG, "w metodzie showDetails(" + index + ") aktywnosci MainActivity");

        if (isMultiPane()) {
        	// Sprawdza, ktry fragment jest wywietlany, w razie potrzeby zamienia go.
            DetailsFragment details = (DetailsFragment)
                    getFragmentManager().findFragmentById(R.id.details);
            if (details == null || details.getShownIndex() != index) {
            	// Tworzy nowy fragment w celu ukazania szczegw zaznaczenia.
                details = DetailsFragment.newInstance(index);
                
                // Przeprowadza operacj zastpienia istniejcego
                // fragmentu fragmentem umieszczonym wewntrz ramki.
                Log.v(TAG, "tuz przed uruchomieniem operacji FragmentTransaction...");
                FragmentTransaction ft
                        = getFragmentManager().beginTransaction();
                // Wicej rodzajw animacji znajdziemy w katalogu res/animator
                ft.setCustomAnimations(R.animator.bounce_in_down,
                		R.animator.slide_out_down);
                //ft.setCustomAnimations(R.animator.fade_in,
                //		R.animator.fade_out);
                //ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_FADE);
                ft.replace(R.id.details, details);
                //ft.addToBackStack(TAG);
                ft.commit();
                getFragmentManager().executePendingTransactions();
            }

        } else {
            // W przeciwnym wypadku musimy uruchomi now aktywno
            // wywietlajc fragment zawierajcy okno dialogowe z zaznaczonym tekstem.
            Intent intent = new Intent();
            intent.setClass(this, DetailsActivity.class);
            intent.putExtra("indeks", index);
            startActivity(intent);
        }
    }
}