package com.androidbook.multitouch.demo2;

// Jest to plik MainActivity.java
import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.widget.RelativeLayout;

public class MainActivity extends Activity implements OnTouchListener {
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        RelativeLayout layout1 = (RelativeLayout) findViewById(R.id.layout1);
        layout1.setOnTouchListener(this);
    }

	public boolean onTouch(View v, MotionEvent event) {
		String myTag = v.getTag().toString();
		Log.v(myTag, "-----------------------------");
		Log.v(myTag, "Uzyskano widok " + myTag + " w metodzie onTouch");
		Log.v(myTag, describeEvent(event));
		logAction(event);
		if( "true".equals(myTag.substring(0, 4))) {
			return true;
		}
		else {
			return false;
		}
	}

	protected static String describeEvent(MotionEvent event) {
		StringBuilder result = new StringBuilder(500);
		result.append("Dziaanie: ").append(event.getAction()).append("\n");
		int numPointers = event.getPointerCount();
		result.append("Ilo wskanikw: ").append(numPointers).append("\n");
        int ptrIdx = 0;
		while (ptrIdx < numPointers) {
		    int ptrId = event.getPointerId(ptrIdx);
            result.append("Indeks wskanika: ").append(ptrIdx);
            result.append(", identyfikator wskanika: ").append(ptrId).append("\n");
            result.append("   Lokacja: ").append(event.getX(ptrIdx));
            result.append(" x ").append(event.getY(ptrIdx)).append("\n");
            result.append("   Sia nacisku: ").append(event.getPressure(ptrIdx));
            result.append("   Rozmiar: ").append(event.getSize(ptrIdx)).append("\n");

            ptrIdx++;
        }
        result.append("Czas dotknicia: ").append(event.getDownTime()).append("ms\n");
        result.append("Czas zdarzenia: ").append(event.getEventTime()).append("ms");
        result.append("  Szacowany: ").append(event.getEventTime()-event.getDownTime());
        result.append(" ms\n");
        return result.toString();
    }

	private void logAction(MotionEvent event) {
	    final String TAG = "Dzialanie";
		int ptrIndex = event.getActionIndex();
		int ptrId = event.getPointerId(ptrIndex);
		int action = event.getActionMasked();

		Log.v(TAG, "Indeks wskaznika: " + ptrIndex);
		Log.v(TAG, "Identyfikator wskaznika: " + ptrId);
		Log.v(TAG, "Prawdziwa wartosc dzialania: " + action);
	}
}