package com.androidbook.gestures;

import java.util.ArrayList;

import android.app.Activity;
import android.gesture.Gesture;
import android.gesture.GestureLibraries;
import android.gesture.GestureLibrary;
import android.gesture.GestureOverlayView;
import android.gesture.Prediction;
import android.gesture.GestureOverlayView.OnGesturePerformedListener;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;

public class MainActivity extends Activity implements OnGesturePerformedListener {
    private static final String TAG = "Wykrywacz gestow";
	GestureLibrary gestureLib = null;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

//        gestureLib = GestureLibraries.fromRawResource(this, R.raw.gestures_letters);
        gestureLib = GestureLibraries.fromFile("/sdcard/gestures");

        // Tutaj moemy zmieni domylne wartoci przed wczytaniem gestw
        //gestureLib.setOrientationStyle(GestureStore.ORIENTATION_INVARIANT);
        //gestureLib.setSequenceType(GestureStore.SEQUENCE_INVARIANT);

        if (!gestureLib.load()) {
            Toast.makeText(this, "Nie mona wczyta pliku /sdcard/gestures", Toast.LENGTH_SHORT).show();
            finish();
        }

        // Przyjrzyjmy si bibliotece gestw, z ktr bdziemy pracowa
        Log.v(TAG, "Funkcje biblioteki:");
        Log.v(TAG, "  Styl ulozenia: " + gestureLib.getOrientationStyle());
        Log.v(TAG, "  Typ sekwencji: " + gestureLib.getSequenceType());
        for( String gestureName : gestureLib.getGestureEntries() ) {
        	Log.v(TAG, "Dla gestu " + gestureName);
        	int i = 1;
            for( Gesture gesture : gestureLib.getGestures(gestureName) ) {
        	    Log.v(TAG, "    " + i + ": ID: " + gesture.getID());
        	    Log.v(TAG, "    " + i + ": Ilosc gestow wlasciwych: " + gesture.getStrokesCount());
        	    Log.v(TAG, "    " + i + ": Dlugosc gestu wlasciwego: " + gesture.getLength());
        	    i++;
            }
        }

        GestureOverlayView gestureView = (GestureOverlayView) findViewById(R.id.gestureOverlay);
        gestureView.addOnGesturePerformedListener(this);

        // Moglibymy wywoa ponisz metod, gdybymy nie zdefiniowali atrybutu
        // android:gestureStrokeType="multiple" w pliku ukadu graficznego.
        //gestureView.setGestureStrokeType(GestureOverlayView.GESTURE_STROKE_TYPE_MULTIPLE);
    }

	public void onGesturePerformed(GestureOverlayView view, Gesture gesture) {
	    ArrayList<Prediction> predictions = gestureLib.recognize(gesture);
	    Log.v(TAG, "w metodzie onGesturePerformed");

	    if (predictions.size() > 0) {
	        Prediction prediction = (Prediction) predictions.get(0);
	        if (prediction.score > 1.0) {
	            Toast.makeText(this, prediction.name, Toast.LENGTH_SHORT).show();
	            for(int i=0;i<predictions.size();i++)
	            	Log.v(TAG, "prognoza " + predictions.get(i).name +
	            			" - wynik = " + predictions.get(i).score);
	        }
	    }
	}
}