package com.androidbook.search.simplesp;

import com.androidbook.search.simplesp.R;

import android.app.Activity;
import android.app.SearchManager;
import android.content.Intent;
import android.os.Bundle;
import android.provider.SearchRecentSuggestions;
import android.util.Log;


//nazwa pliku: SearchActivity.java
public class SearchActivity extends Activity 
{
	private final static String tag ="SearchActivity";
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        Log.d(tag,"Jestem tworzona");
        //w przeciwnym wypadku wykonuje t czynno
        setContentView(R.layout.layout_test_search_activity);
    	//this.setDefaultKeyMode(Activity.DEFAULT_KEYS_SEARCH_GLOBAL);
    	this.setDefaultKeyMode(Activity.DEFAULT_KEYS_SEARCH_LOCAL);
    	
    	// umieszcza tutaj i przetwarza kwerend wyszukiwania
        final Intent queryIntent = getIntent();
        final String queryAction = queryIntent.getAction();
        if (Intent.ACTION_SEARCH.equals(queryAction)) 
        {
        	Log.d(tag,"nowa intencja dla wyszukiwania");
        	this.doSearchQuery(queryIntent);
        }
        else {
        	Log.d(tag,"nowa intencja NIE dla wyszukiwania");
        }
        return;
    }
    
    @Override
    public void onNewIntent(final Intent newIntent) 
    {
        super.onNewIntent(newIntent);
        Log.d(tag,"nowa intencja mnie wywoluje");
        
        // umieszcza tutaj i przetwarza kwerend wyszukiwania
        final Intent queryIntent = getIntent();
        final String queryAction = queryIntent.getAction();
        if (Intent.ACTION_SEARCH.equals(queryAction)) 
        {
        	this.doSearchQuery(queryIntent);
        	Log.d(tag,"nowa intencja dla wyszukiwania");
        }
        else {
        	Log.d(tag,"nowa intencja NIE dla wyszukiwania");
        }
    }
    private void doSearchQuery(final Intent queryIntent) 
    {
        final String queryString = 
        	queryIntent.getStringExtra(SearchManager.QUERY);
        
        // Zapisuje cig znakw kwerendy w biecym dostawcy propozycji kwerend.
        SearchRecentSuggestions suggestions = new SearchRecentSuggestions(this, 
        		SimpleSuggestionProvider.AUTHORITY, 
        		SimpleSuggestionProvider.MODE);
        suggestions.saveRecentQuery(queryString, "SSSP");
    }
}
    
