package com.androidbook.bcr;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
/*
* Odbiorca ten zosta wprowadzony w celu ukazania,
* w jaki sposb gwny wtek ustala kolejno przetwarzania odbiorcw komunikatw
*
* przykad ten pomaga odpowiedzie na takie pytania, jak:
* 1. Czy s oni przywoywani w kolejnoci ich definiowania w pliku manifecie?
* 2. S one przetwarzane jeden po drugim czy te rwnolegle?
*
* Widzimy, e za pomoc opnienia czasowego wprowadzamy gwny wtek
* w stan wstrzymania na tyle wanie sekund. Wida to 
* w pliku wynikowym Log.d
*/
public class TestTimeDelayReceiver extends BroadcastReceiver 
{
	private static final String tag = "TestTimeDelayReceiver"; 
    @Override
    public void onReceive(Context context, Intent intent) 
    {
    	Utils.logThreadSignature(tag);
        Log.d(tag, "intencja=" + intent);
        Log.d(tag, "przechodzi w stan bezczynnosci na 2 sekundy");
        Utils.sleepForInSecs(2);
        Log.d(tag, "wybudzanie");
        String message = intent.getStringExtra("message");
        Log.d(tag, message);
    }
}

