package com.androidbook.bcr;

import com.androidbook.bcr.R;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.TextView;

public class TestBCRActivity extends Activity 
{
	public static final String tag="TestBCRActivity";
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
    }
    @Override
    public boolean onCreateOptionsMenu(Menu menu){ 
    	super.onCreateOptionsMenu(menu);
 	   	MenuInflater inflater = getMenuInflater(); //z aktywnoci
 	   	inflater.inflate(R.menu.main_menu, menu);
    	return true;
    }
    @Override
    public boolean onOptionsItemSelected(MenuItem item){ 
    	appendMenuItemText(item);
    	if (item.getItemId() == R.id.menu_clear){
    		this.emptyText();
    		return true;
    	}
    	if (item.getItemId() == R.id.menu_send_broadcast){
    		this.testSendBroadcast();
    		return true;
    	}
    	return true;
    }
    private TextView getTextView(){
        return (TextView)this.findViewById(R.id.text1);
    }
    private void appendMenuItemText(MenuItem menuItem){
       String title = menuItem.getTitle().toString();
       TextView tv = getTextView(); 
       tv.setText(tv.getText() + "\n" + title);
    }
    private void emptyText(){
          TextView tv = getTextView();
          tv.setText("");
    }
    private void testSendBroadcast()
    {
    	//Wywietla identyfikator dziaajcego wtku
    	Utils.logThreadSignature(tag);
    	
    	//Tworzy intencj zawierajc dziaanie
    	Intent broadcastIntent = new Intent("com.androidbook.intents.testbc");
    	//Zapisuje w intencji komunikat,
        //ktry chcemy nada
    	broadcastIntent.putExtra("komunikat", "Witaj wiecie");
    	
    	//Wysya komunikat
        //Moe go odczyta wielu odbiorcw
    	this.sendBroadcast(broadcastIntent);
    	
    	//Wywietla komunikat po wysaniu go do odbiorcy
        //Powinien on pojawi si najpierw w pliku dziennika
        //jeszcze przed komunikatami pochodzcymi z transmisji
        //poniewa dziaaj one w tym samym wtku
    	Log.d(tag,"po wyslaniu komunikatu z glownego menu");
    }
}