package com.androidbook.salbcr;

import android.content.Context;
import android.content.Intent;
import android.app.IntentService;
import android.app.Service;

public abstract class ALongRunningNonStickyBroadcastService 
extends IntentService
{
	public static String tag = "ALongRunningBroadcastService";
	protected abstract void 
	handleBroadcastIntent(Intent broadcastIntent);
	
	public ALongRunningNonStickyBroadcastService(String name){ 
		super(name);	
	}	
	   /*
	   * Metoda ta moe zosta wywoana w dwch przypadkach:
	   * 1. Gdy odbiorca komunikatw dostarcza metod startService
	   * 2. Gdy Android ponownie j uruchamia z powodu oczekujcych intencji.
	   *
	   * W pierwszym przypadku odbiorca komunikatw zdy
	   * ju skonfigurowa owietlony, zielony pokj.
	   *
	   * W drugim przypadku musimy zrobi to samo.
	   */
	@Override
	public void onCreate() 
	{
		super.onCreate();
		
	      //Konfiguruje zielony pokj
	      //Konfigurator ten mona wywoywa wiele razy.
		LightedGreenRoom.setup(this.getApplicationContext());

	      //Istnieje spore prawdopodobiestwo, e istnieje wicej uruchomionych
	      //usug tego typu.
	      //Znajomo ich iloci pozwoli nam usun blokady budzenia
	      //w trakcie wywoywania metody ondestroy.
		LightedGreenRoom.s_registerClient();
	}
	@Override
	public int onStartCommand(Intent intent, int flag, int startId) 
	{
		//Wywouje metod onStart klasy IntentService
		super.onStart(intent, startId);
		
		//Informuje zielony pokj o obecnoci gocia
		LightedGreenRoom.s_enter();
		
	    //zaznaczamy usug jako nietrwa
	    //Znaczenie: usuga nie jest ponownie uruchamiana, jeli nie ma
	    //oczekujcych intencji.
		return Service.START_NOT_STICKY;
	}
	/*
	* Zwrmy uwag, e wywoanie tej metody przebiega
	* w wtku drugoplanowym, skonfigurowanym przez klas IntentService.
	*
	* Przesaniamy t metod z poziomu klasy IntentService.
	* Odczytujemy oryginaln, nadawan intencj.
	* Wywoujemy pochodn klas, zajmujc si intencj nadawanego komunikatu.
	* Na kocu owietlony, zielony pokj zostaje poinformowany, e go wychodzi.
	* W przypadku ostatniego gocia blokada
	* zostanie zwolniona.
	*/
	@Override	
	final protected void onHandleIntent(Intent intent) 
	{		
		try 
		{			
			Intent broadcastIntent
			= intent.getParcelableExtra("original_intent");
			handleBroadcastIntent(broadcastIntent);
		}		
		finally 
		{
			LightedGreenRoom.s_leave();
		}	
	}
	/*
	* Jeeli Android odzyska proces,
	* metoda ta zwolni blokad
	* niezalenie od iloci obecnych goci.
	*/
	@Override
	public void onDestroy() {
		super.onDestroy();
		LightedGreenRoom.s_unRegisterClient();
	}
}
