#!/usr/bin/perl

sub dopasowanie_naiwne_lancuchow {
    my ( $duzy, $pod ) = @_; # Duzy i mniejszy podlancuch.

    use integer;        # Aby bylo szybciej.

    my $duzy_dlugosc = length( $duzy );
    my $pod_dlugosc = length( $pod );

    return -1 if $duzy_dlugosc < $pod_dlugosc;   # Za dlugi wzorzec!

    my ( $i, $j, $dopasowanie_j );
    my $ostatni_i = $duzy_dlugosc - $pod_dlugosc;
    my $ostatni_j = $pod_dlugosc - 1;

    for ( $i = 0; $i <= $ostatni_i; $i++ ) {
        for ( $j = 0, $dopasowanie_j = -1;
              $j < $pod_dlugosc &&
              substr( $pod, $j, 1 ) eq substr( $duzy, $i + $j, 1 );
              $j++ ) {
           $dopasowanie_j = $j;
        }
        return $i if $dopasowanie_j == $ostatni_j; # Znalezlismy.
    }

    return -1; # Brak dopasowania.
}

print dopasowanie_naiwne_lancuchow( "abcdefgh", "def" ), " ",
      dopasowanie_naiwne_lancuchow( "abcdefgh", "deg" ), "\n";
