#!/usr/bin/perl

use integer;

my $Sigma = 256;                        # Rozmiar alfabetu.
my @po2 = map { 1 << $_ } 0..31;        # Przechowuje potegi dwojki.
my $debug = 1;                          # Dla chorobliwie ciekawych.

sub amatch {
    my $P = shift;      # Wzorzec.
    my $k = shift;      # Stopien przyblizenia.

    my $m = length $P;  # Rozmiar wzorca.
    # Jesli nie zostal podany stopien przyblizenia, zakladamy 10% rozmiaru wzorca.
    $k = (10 * $m) / 100 + 1 unless defined $k;

    # Konwertujemy wzorzec na maske bitowa.
    my @T = (0) x $Sigma;
    for (my $i = 0; $i < $m; $i++) {
        $T[ord(substr($P, $i))] |= $po2[$i];
    }
    if ($debug) {
        for (my $i = 0; $i < $Sigma; $i++) {
            printf "T[%c] = %s\n",
                $i, unpack("b*", pack("V", $T[$i])) if $T[$i];
        }
    }

    my (@s, @r); # s: biezacy stan, r: poprzedni stan.
    # Inicjujemy poprzednie stany.
    for ($r[0] = 0, my $i = 1; $i <= $k; $i++) {
        $r[$i] = $r[$i-1];
        $r[$i] |= $po2[$i-1];
    }
    if ($debug) {
        for (my $i = 0; $i <= $k; $i++) {
            print "r[$i] = ", unpack("b*", pack("V", $r[$i])), "\n";
        }
    }

    my $n  = length();   # Rozmiar tekstu.
    my $mb = $po2[$m-1]; # Jesli bit sie swieci, mamy rybe w sieci.

    for ($s[0] = 0, my $i = 0; $i < $n; $i++) {
        $s[0] <<= 1;
        $s[0] |= 1;
        my $Tc = $T[ord(substr($_, $i))]; # Biezacy znak.
        $s[0] &= $Tc;   # Dokladne dopasowanie.
        print "$i s[0] = ", unpack("b*", pack("V", $s[0])), "\n"
            if $debug;
        for (my $j = 1; $j <= $k; $j++) { # Przyblizone dopasowanie.
            $s[$j]  = ($r[$j] << 1) & $Tc;
            $s[$j] |= ($r[$j-1] | $s[$j-1]) << 1;
            $s[$j] |= $r[$j-1];
            $s[$j] |= 1;
            print "$i s[$j] = ", unpack("b*", pack("V", $s[$j])), "\n"
                if $debug;
        }
        return $i > $m ? $i - $m : 0 if $s[$k] & $mb; # Mamy dopasowanie
        @r = @s;
    }

    return -1; # Brak dopasowania.
}

my $P = @ARGV ? shift : "perl";
my $k = shift if @ARGV;

while (<STDIN>) {
    print if amatch($P, $k) >= 0;
}


