#!/usr/bin/perl

use integer;    # Nie potrzebujemy tu liczb zmiennoprzecinkowych.

my ( $SLOWA, %SLOWA );

SCAN_WORDS: { # Lokalizujemy liste slow: zalezy od lokalnego Unixa.
    my ( $SLOWA_katalog );

    foreach $SLOWA_katalog ( qw(/usr/share/dict /usr/dict .) ) {
        $SLOWA = "$SLOWA_katalog/words";
        last SCAN_WORDS if -f $SLOWA;
    }
}

die "$0: nie udalo sie znalezc listy slow-rdzeni.\n" unless -f $SLOWA;

print "Lista slow znaleziona pod '$SLOWA'.\n";

open( WORDS, $SLOWA ) or die "$0: nie udalo sie otworzyc pliku '$SLOWA': $!\n";

sub znajdz_slowo {
    my $slowo = $_[0]; # Poszukiwane slowo.

    use Search::Dict;

    unless ( exists $SLOWA{ $slowo } ) {
        # Jesli $slowo nie bylo jeszcze sprawdzane.
        my $pos = look( *WORDS, $slowo, 0, 1 );

        if ( $pos < 0 ) {
            # Jesli $slowo bylo juz sprawdzane bez powodzenia.
            $SLOWA{ $slowo } = 0;
        } else {
            my $line = <WORDS>;
            chomp( $line );

            # Jeden $slowo bylo sprawdzane, 1 jesli jest, 0 jesli go nie ma.
            $SLOWA{ $slowo } = lc( $line ) eq lc( $slowo );
        }
    }

    return $SLOWA{ $slowo };
}

sub powrot_do_rdzenia { # Slowo, ktorego rdzenia szukamy, zasady szukania, 
                 # i dotychczasowy wynik.
    my ( $slowo, $zasady, $sciezka ) = @_; 

    @$sciezka = ( $slowo ) unless defined $sciezka;
    if ( znajdz_slowo( $slowo ) ) {
        print "@$sciezka\n";
        return;
    }

    my ( $i, $robocze );

    for ( $i = 0; $i < @$zasady; $i += 2 ) {
        my $src = $zasady->[ $i   ];
        my $dst = $zasady->[ $i+1 ];
        $robocze = $slowo;
        if ( $dst =~ /\$/ ) {   # Zlozona, jedno wiecej /e.
            while ( $robocze =~ s/$src/$dst/eex ) {
                powrot_do_rdzenia( $robocze, $zasady, [ @$sciezka, $robocze ] );
            }
        } else {                # Prosta zasada.
            while ( $robocze =~ s/$src/$dst/ex ) {
                powrot_do_rdzenia( $robocze, $zasady, [ @$sciezka, $robocze ] );
            }
        }
    }
    return;
}

# Zasady skladaja sie z dwoch czesci: &quot;before&quot; oraz &quot;after&quot;, z s///.

# Proste zasady.

my @ZASADY = split(/\s*,\s*/, <<'__ZASADY__', -1);
^bi     ,       ,       ^de     ,       ,
^dis    ,       ,       ^hyper  ,       ,
^mal    ,       ,       ^mega   ,       ,
^mid    ,       ,       ^re     ,       ,
^sub    ,       ,       ^super  ,       ,
^tri    ,       ,       ^un     ,       ,
able$   ,       ,       al$     ,       ,
d$      ,       ,       ed$     ,       ,
est$    ,       ,       ful$    ,       ,
hood$   ,       ,       ian$    ,       ,
ic$     ,       ,       ing$    ,       ,
on$     ,       ,       ise$    ,       ,
ist$    ,       ,       ity$    ,       ,
ive$    ,       ,       ize$    ,       ,
less$   ,       ,       like$   ,       ,
ly$     ,       ,       ment$   ,       ,
ness$   ,       ,       s$      ,       ,
worthy$ ,       ,
iable$  ,       y,      ian$    ,       y,
ic$     ,       y,      ial$    ,       y,
iation$ ,       y,      ier$    ,       y,
iest$   ,       y,      iful$   ,       y,
ihood$  ,       y,      iless$  ,       y,
ily$    ,       y,      iness$  ,       y,
ist$    ,       y,
able$   ,       e,      ation$  ,       e,
ing$    ,       e,      ion$    ,       e,
ise$    ,       e,      ism$    ,       e,
ist$    ,       e,      ity$    ,       e,
ize$    ,       e,
ce$     ,       t,      cy$     ,       t
__ZASADY__

# Porzucamy pojawiajace sie przypadkiem puste pole na koncu.
pop( @ZASADY ) if @ZASADY % 2 == 1;

# Zlozone zasady.

my $C = '[bcdfghjklmnpqrstvwxz]';

push( @ZASADY, "($C)".'\1(?: ing|ed)$', '$1' );

# Zasady usuwania spacji.

foreach ( @ZASADY ) {
    s/^\s+//;
    s/\s+$//;
}

# Wykonujemy odnajdywanie rdzenia.

while ( <STDIN> ) {
    chomp;
    powrot_do_rdzenia( $_, \@ZASADY );
}
