#!/usr/bin/perl

sub mergesort {
    mergesort_rekurenc($_[0], 0, $#{ $_[0] });
}

sub mergesort_rekurenc {
    my ( $tablica, $pierwszy, $ostatni ) = @_;

    if ( $ostatni > $pierwszy ) {
        local $^W = 0;               # Wylaczanie ostrzezenia przed rekurencyjnoscia.
        my $srodkowy = int(( $ostatni + $pierwszy ) / 2);

        mergesort_rekurenc( $tablica, $pierwszy,       $srodkowy );
        mergesort_rekurenc( $tablica, $srodkowy + 1,  $ostatni   );
        merge( $tablica, $pierwszy, $srodkowy, $ostatni );
    }
}

my @robocza; # Globalna tablica robocza.

sub merge {
    my ( $tablica, $pierwszy, $srodkowy, $ostatni ) = @_;

    my $n = $ostatni - $pierwszy + 1;

    # Inicjujemy tablice robocza odpowiednimi elementami z tablicy.
    for ( my $i = $pierwszy, my $j = 0; $i <= $ostatni; ) {
        $robocza[ $j++ ] = $tablica->[ $i++ ];
    }

    # Teraz rzeczywiste polaczenie. Przegladamy tablice i kopiujemy
    # elementy w porzadku z powrotem do oryginalnej tablicy.
    # $i to indeks wyniku polaczenia, $j to indeks w pierwszej
    # polowie kopii roboczej, $k to indeks w drugiej polowie.

    $srodkowy = int(($pierwszy + $ostatni) / 2) if $srodkowy > $ostatni;

    my $n1 = $srodkowy - $pierwszy + 1;    # Rozmiar pierwszej polowy.

    for ( my $i = $pierwszy, my $j = 0, my $k = $n1; $i <= $ostatni; $i++ ) {
        $tablica->[ $i ] =
            $j < $n1 &&
              ( $k == $n || $robocza[ $j ] lt $robocza[ $k ] ) ?
                $robocza[ $j++ ] :
                $robocza[ $k++ ];
    }
}

@tablica = qw(mysle ze powinienem wykorzystac te przyklady, by powiedziec cos waznego,
	    nie uwazacie?  w koncu beda je czytac TYSIACE ludzi i warto by im cos
            przekazac. ale wszystko co mam do powiedzenia, to ze nie mam nic do powiedzenia.);

mergesort \@tablica;

print "@tablica\n";
