#!/usr/bin/perl

@Psowate{ qw(pies wilk) } = ( );

( $size, $liczby, $nazwy ) = elementy_na_liczby( \%Psowate );

$Psowate = tablica_asoc_na_wektor_bitow( \%Psowate, $liczby );

print "Psowate = ",
  "@{ [keys %{ wektor_bitow_na_tablice_asoc( $Psowate, $nazwy ) } ] }\n";

sub elementy_na_liczby {
    my ( @nazwy,   $nazwa );
    my ( %liczby, $liczba );

    $liczba = 0;
    while ( my $zbior = shift @_ ) {
        while ( defined ( $nazwa = each %$zbior ) ) {
            unless ( exists $liczby{ $nazwa } ) {
        $liczby{ $nazwa   } = $liczba;
        $nazwy  [ $liczba ] = $nazwa;
        $liczba++;
            }
        }
    }

    return ( $liczba, \%liczby, \@nazwy );
}

sub tablica_asoc_na_wektor_bitow {
    my ( $hash, $liczby ) = @_;
    my ( $nazwa, $wektor );

    # Inicjujemy $wektor bitami zerowymi.
    #
    $wektor = '';

    while ( defined ($nazwa = each %{ $hash })) {
        vec( $wektor, $liczby->{ $nazwa }, 1 ) = 1;
    }

    return $wektor;
}

sub wektor_bitow_na_tablice_asoc {
    my ( $wektor, $nazwy ) = @_;
    my ( $liczba, %zbior_tablica_asoc );

    foreach $liczba ( 0..$#{ $nazwy }) {
        $zbior_tablica_asoc{ $nazwy->[ $liczba ] } = undef
            if vec( $wektor, $liczba, 1 );
    }

    return \%zbior_tablica_asoc;
}
