#!/usr/bin/perl -w

sub roznica {
    my %roznica;
  
    @roznica{ keys %{ shift() } } = ( );

    while ( @_ and keys %roznica ) {
        # Usuwamy z roznicy zbiorow wszystkie elementy
        # ktore sa rowniez w kolejnym zbiorze.
        delete @roznica{ keys %{ shift() } };
    }
    
    return \%roznica;
}

@Psowate     { qw(pies wilk)      } = ( );
@Udomowione{ qw(pies kot kon) } = ( );

$roznica = roznica(\%Psowate, \%Udomowione);
print join(' ', keys %$roznica), "\n";

sub symetryczna_roznica {
    my %symetryczna_roznica;

    my ( $element, $zbior );

    while ( defined ( $zbior = shift( @_ ) ) ) {
        while ( defined ( $element = each %$zbior ) ) {
            $symetryczna_roznica{ $element }++;
        }
    }
    delete @symetryczna_roznica{
        grep( ( $symetryczna_roznica{ $_ } & 1 ) == 0,
             keys %symetryczna_roznica)
    };
    return \%symetryczna_roznica;
}

@Polarny{ qw(niedzwiedz_polarny pingwin)    } = ();
@Niedzwiedz{  qw(niedzwiedz_polarny niedzwiedz_brunatny) } = ();
@Ptak{  qw(pingwin kondor)        } = ();

$SymRoznica_niedzwiedz_polarny_Ptak =
    symetryczna_roznica( \%Polarny, \%Niedzwiedz, \%Ptak );

print join(" ", keys %{ $SymRoznica_niedzwiedz_polarny_Ptak }), "\n";
