#!/usr/bin/perl

my $NIEZLE_Q = 8355967;

# rabin_karp_suma( $S, $q, $n )
#
# $S to sumowany lancuch
# $q to podstawa modulo (domyslnie $NIEZLE_Q)
# $n to dlugosc sumowanego lancucha (domyslnie length($S))

sub rabin_karp_suma_modulo_q {
    my ( $S ) = shift; # Lancuch.

    use integer; # Uzywamy tylko liczb calkowitych.

    my $q = @_ ? shift : $NIEZLE_Q;
    my $n = @_ ? shift : length( $S );

    my $Sigma = 256; # Zakladamy, ze tekst jest z 8-bitowych znakow.

    my ( $i, $suma, $najw_pot );

    if ( @_ ) { # Sumowanie przyrostowe.
        ( $i, $suma, $najw_pot ) = @_;

        if ($i > 0) {
            my $najw_czynn; # Uwzglednienie najwyzszej cyfry.

            $najw_czynn  = $najw_pot * ord( substr( $S, $i - 1, 1 ) );
            $najw_czynn %= $q;
            $suma -= $najw_czynn;
        }

        $suma *= $Sigma;
        $suma += ord( substr( $S, $n + $i - 1, 1 ) );
        $suma %= $q;

        return $suma; # Suma.
    } else {            # Pelne sumowanie.
        ( $suma, $najw_pot ) = ( ord( substr( $S, 0, 1 ) ), 1 );

        for ( $i = 1; $i < $n; $i++ ) {
            $suma *= $Sigma;
            $suma += ord( substr( $S, $i, 1 ) );
            $suma %= $q;

            $najw_pot *= $Sigma;
            $najw_pot %= $q;
        }

        # Warto zauwazyc, ze w kontekscie tablicy zwracamy rowniez
        # najwyzszy uzywany mnoznik mod $q liczb, jako $najw_pot,
        # n.p., 256**4 mod $q == 3599 dla $n == 5.

        return wantarray ? ( $suma, $najw_pot ) : $suma;
    }
}

sub rabin_karp_modulo_q {
    my ( $T, $P, $q ) = @_; # Lancuch, wzorzez i opcjonalnie modulo.

    use integer;

    my $n = length( $T );
    my $m = length( $P );

    return -1 if $m  > $n;
    return  0 if $m == $n and $P eq $T;

    $q = $NIEZLE_Q unless defined $q;

    my ( $KRsuma_P, $najw_pot ) = rabin_karp_suma_modulo_q( $P, $q, $m );
    my ( $KRsuma_T )         = rabin_karp_suma_modulo_q( $T, $q, $m );

    return 0 if $KRsuma_T == $KRsuma_P and substr( $T, 0, $m ) eq $P;

    my $i;
    my $ostatnie_i = $n - $m; # $i bedzie wzrastac od 1 do $ostatnie_i.

    for ( $i = 1; $i <= $ostatnie_i; $i++ ) {

        $KRsuma_T =
            rabin_karp_suma_modulo_q( $T, $q, $m, $i, $KRsuma_T, $najw_pot );

        return $i
            if $KRsuma_T == $KRsuma_P and substr( $T, $i, $m ) eq $P;
    }

    return -1; # Brak dopasowania.
}
