#!/usr/bin/perl

sub knuth_morris_pratt_nastepny {
    my ( $P ) = @_; # Wzorzec.

    use integer;

    my ($m, $i, $j ) = ( length $P, 0, -1 );
    my @nastepny;

    for ($nastepny[0] = -1; $i < $m; ) {
        # Zauwazcie, ze while() jest pomijane w pierwszym nawrocie petli for().
        while ( $j > -1 &&
                substr( $P, $i, 1 ) ne substr( $P, $j, 1 ) ) {
            $j = $nastepny[ $j ];
        }
        $i++;
        $j++;
        $nastepny[ $i ] =
            substr( $P, $j, 1 ) eq substr( $P, $i, 1 ) ?
                $nastepny[ $j ] : $j;
     }

    return ( $m, @nastepny ); # Dlugosc wzorca i funkcji przedrostka.
}

sub knuth_morris_pratt {
    my ( $T, $P ) = @_; # Tekst i wzorzec.

    use integer;

    my ($m, @nastepny) = knuth_morris_pratt_nastepny( $P );
    my ($n, $i, $j) = (length($T), 0, 0);

    while ( $i < $n ) {
        while ( $j > -1 &&
                substr( $P, $j, 1 ) ne substr( $T, $i, 1 ) ) {
            $j = $nastepny[ $j ];
        }
        $i++;
        $j++;
        return $i - $j if $j >= $m; # Brak dopasowania.
    }

    return -1; # Brak dopasowania.
}
