#!/usr/bin/perl

# TransitiveClosure_Floyd_Warshall
#
#       $TransitiveClosure = $G->TransitiveClosure_Floyd_Warshall
#
#       Zwraca graf zamkniecia przechodniego dla grafu $G wyliczony
#       za pomoca algorytmu Floyda-Warshalla.
#       Wynikowy graf bedzie posiadal krawedz miedzy kazda z *uporzadkowanych*
#       par wierzcholkow, w ktorych drugi wierzcholek jest zawsze osiagalny
#       z pierwszego.
#

sub TransitiveClosure_Floyd_Warshall {
    my $G = shift;
    my @V = $G->vertices;
    my @E = $G->edges;
    my (%V2I, @I2V);
    my @C = ( '' ) x @V;

    # Wyliczamy wierzcholek <-> mapowanie indeksu.
    @V2I{ @V     } = 0..$#V;
    @I2V[ 0..$#V ] = @V;

    # Inicjujemy macierz zamkniecia @C.
    # (Graf jest konwertowany na macierz sasiedztwa.)
    # (Macierz to macierz bitowa. Czyli lista wektorow bitow.)
    foreach my $i ( 0..$#V ) { vec( $C[ $i ], $i, 1 ) = 1 }
    while ( my ($u, $v) = splice(@E, 0, 2) ) {
        vec( $C[ $V2I{ $u } ], $V2I{ $v }, 1 ) = 1
    }

    # Wykonujemy petle O(N**3).
    for ( my $k = 0; $k < @V; $k++ ) {
    for ( my $i = 0; $i < @V; $i++ ) {  
        next unless vec( $C[ $i ], $k, 1 );
        for ( my $j = 0; $j < @V; $j++ ) {
            vec( $C[ $i ], $j, 1 ) |= vec( $C[ $k ], $j, 1 );
        }
    }
    }

    # Teraz konstruujemy graf zamkniecia, TransitiveClosure.

    my $TransitiveClosure = (ref $G)->new;

    $TransitiveClosure->directed( $G->directed ); # Kopiujemy skierowanie.

    # Konwertujemy macierz sasiedztwa (dla zamkniecia przechodniego)
    # na graf (w postaci listy sasiedztwa).
    for ( my $i = 0; $i < @V; $i++ ) {
        for ( my $j = 0; $j < @V; $j++ ) {
            $TransitiveClosure->add_edge( $I2V[ $i ], $I2V[ $j ] )
                if vec( $C[ $i ], $j, 1 );
        }
    }

    return $TransitiveClosure;
}
