#!/usr/bin/perl

use kolko_i_krzyzyk;  # zdefiniowane wczesniej w rozdziale

# wyczerpujaca analiza gry w kolko i krzyzyk
sub ttt_wyczerpujaca {

    my $gra = kolko_i_krzyzyk->new( );

    my $odpowiedz = ttt_analiza( $gra );
    if ( $odpowiedz > 0 ) {
        print "Gracz 1 powinien wygrac\n";
    } elsif ( $odpowiedz < 0 ) {
        print "Gracz 2 powinien wygrac\n";
    } else {
        print "Remis\n";
    }
}

# $odpowiedz = ttt_analiza( $gra )
#    Ustalamy, czy wygra drugi gracz.  Jesli nie, trzeba
#     wyprobowac dla niego wszystkie dostepne ruchy (z $dostep).
sub ttt_analiza {
    my $gra = shift;

    unless ( defined $gra->przygotuj_ruchy ) {
        # Nie ma zadnego ruchu.  Albo ktorys z graczy wygral,
        # albo jest remis.
        my $wynik = $gra->oceniaj;
        return -1 if $wynik < 0;
        return 0;
    }

    # Znajdz najlepszy wynik wszystkich mozliwych ruchow.
    my $najlepsza_ocena = -1;

    while ( defined( $ruch = $gra->nastepny_ruch ) ) {
        # Niech ruch daje ujemny wynik
        #   - to co jest dobre dla przeciwnika, jest zle dla nas.
        my $ten_wynik = - ttt_analiza( $gra->wykonaj_ruch( $ruch ) );

        # oceniaj
        $najlepsza_ocena = $ten_wynik if $ten_wynik > $najlepsza_ocena;
    }

    return $najlepsza_ocena;
}

&ttt_wyczerpujaca;
