#!/usr/bin/perl

sub dzielenie {
    my ( $dzielenie, $pierwszy, $ostatni ) = @_;

    my $i = $pierwszy;
    my $j = $ostatni - 1;
    my $nasza_os = $dzielenie->[ $ostatni ];

 SKAN: {
        do {
            # $pierwszy <= $i <= $j <= $ostatni - 1
            # Punkt 1.

            # Przenosimy $i tak daleko, jak sie da.
            while ( $dzielenie->[ $i ] le $nasza_os ) {  
                $i++;
                last SKAN if $j < $i;
            }

            # Przenosimy $j tak daleko, jak sie da.
            while ( $dzielenie->[ $j ] ge $nasza_os ) {
                $j--;
                last SKAN if $j < $i;
            }

            # $i i $j nie spotykaja sie, wiec zamieniamy obie miejscami 
            @$dzielenie[ $j, $i ] = @$dzielenie[ $i, $j ];
        } while ( --$j >= ++$i );
    }
    # $pierwszy - 1 <= $j < $i <= $ostatni
    # Punkt 2.

    # Zamieniamy nasza os z pierwszym wiekszym elementem (jesli taki jest).
    if ( $i < $ostatni ) {
        @$dzielenie[ $ostatni, $i ] = @$dzielenie[ $i, $ostatni ];
        ++$i;
    }

    # Punkt 3.

    return ( $i, $j );   # Nowe granice wykluczaja srodek.
}

sub quicksort_rekurenc {
    my ( $dzielenie, $pierwszy, $ostatni ) = @_;

    if ( $ostatni > $pierwszy ) {
        my ( $pierwszy_z_ostatnich, $ostatni_z_pierwszych ) =
                                dzielenie( $dzielenie, $pierwszy, $ostatni );

        local $^W = 0;               # Wylaczamy ostrzezenia przed rekurencja.
        quicksort_rekurenc($dzielenie, $pierwszy,         $ostatni_z_pierwszych);
        quicksort_rekurenc($dzielenie, $pierwszy_z_ostatnich, $ostatni);
    }
}

sub quicksort {
    # Wersja rekurencyjna nie sprawdza sie dla DLUGICH list
    # poniewaz stos funkcji zbyt sie rozrasta.
    quicksort_rekurenc($_[ 0 ], 0, $#{ $_[ 0 ] });
}

# Jesli mozna oczekiwac, ze wiele kluczy bedzie takich samych, dodajcie
# przed <LITERAL>return</LITERAL> w <LITERAL>dzielenie()</LITERAL>:
#
# Rozszerzamy srodek dzielenia, tak daleko, jak sie da.
#
# ++$i while $i <= $ostatni  && $dzielenie->[ $i ] eq $nasza_os;
# --$j while $j >= $pierwszy && $dzielenie->[ $j ] eq $nasza_os;

@dzielenie = qw(Male naciecia na brzegach monet nazywamy karbowaniem.);

quicksort( \@dzielenie );

print "@dzielenie\n";
