#!/usr/bin/perl

# pakiet obslugujacy gre w kolko i krzyzyk
package kolko_i_krzyzyk;

$pusty = ' ';
@ruch = ( 'X', 'O' );
# Mapujemy X i O na 0 i 1.
%ruch = ( 0=>0, 1=>1, 'X'=>0, 'O'=>1 );

# new( tura, plansza )
#
# By utworzyc nowa gre w kolki i krzyzyk:
#    kolko_i_krzyzyk->new( )
#

# Procedura ta jest rowniez uzywana wewnetrznie, zeby utworzyc pozycje, 
# ktora pojawi sie po ruchu, przelaczajac sie w zaleznosci od tego czyja
# jest tura i dodajac ruch do planszy:
#    $plansza = ... dopasowujemy biezaca plansze do wykonywanego ruchu
#    kolko_i_krzyzyk->new( 1 - $self->{tura}, $plansza )
sub new {
    my ( $pkg, $tura, $plansza ) = @_;
    $tura = 0 unless defined $tura;
    $tura = $ruch{$tura};
    $plansza = [ ($pusty) x 9 ] unless defined $plansza;
    my $self = { tura => $tura, plansza => $plansza };
    bless $self, $pkg;
    $self->oceniaj_wynik;

    return $self;
}

# Przechowujemy wynik dla pozycji, wyliczajac go gdy pozycja
# jest tworzona po raz pierwszy. Podajemy wartosc z punktu
# widzenia gracza, ktory sie wlasnie ruszyl.
#
# zasady oceny:
#       100 wygrana gracza (-100 przeciwnika)
#        10 za kazde nieblokowane 2 w rzedzie (-10 przeciwnika)
#         1 za kazde nieblokowane 1 w rzedzie (-1 przeciwnika)
#         0 za kazdy blokowany rzad
sub oceniaj_wynik {
    my $self  = shift;
    my $ja    = $ruch[1 - $self->{tura}];
    my $on   = $ruch[$self->{tura}];
    my $plansza = $self->{plansza};
    my $wynik = 0;

    # Skanuj wszystkie mozliwe linie.
    foreach $linia (
		   [0,1,2], [3,4,5], [6,7,8],   # rzedy
		   [0,3,6], [1,4,7], [2,5,8],   # kolumny
		   [0,4,8], [2,4,6] )           # przekatne
    {
	my ( $moj, $jego );
	foreach (@$linia) {
	    my $wlasciciel = $plansza->[$_];

	    ++$moj if $wlasciciel eq $ja;
	    ++$jego if $wlasciciel eq $on;
	}

	# Zadnych punktow, jesli linia jest blokowana.
	next if $moj && $jego;

	# Przegrana.
	return $self->{wynik} = -100 if $jego == 3;

	# Nie mozna wygrac w ruchu przeciwnika.
	return $self->{wynik} = 100 if $moj == 3;

	# Przyznajemy 10 za 2 w linii, 1 za 1 w linii.
	$wynik +=
	    ( -10, -1, 0, 1, 10 )[ 2 + $moj - $jego ];
    }

    return $self->{wynik} = $wynik;
}

# Przygotowanie do wygenerowania kazdego mozliwego ruchu z pozycji.
sub przygotuj_ruchy {
    my $self = shift;

    # Nie mozna wykonac zadnego, jesli ktos wygral.
    return undef if abs($self->{wynik}) == 100;

    # Sprawdzamy, czy sa mozliwe jakies ruchy:
    $self->{nastepny_ruch} = -1;
    return undef unless defined( $self->nastepny_ruch );

    # There are.  Next time we'll return the first one.
    return $self->{nastepny_ruch} = -1;
}

# Ustalamy nastepny mozliwy ruch z tej pozycji.
# zwracamy undef jesli nie ma zadnego ruchu.
sub nastepny_ruch {
    my $self = shift;

    # Zwracamy tez undef, jesli juz skonczylismy.
    return undef unless defined $self->{nastepny_ruch};

    # Sprawdzamy wszystkie pozostale pola, pomijajac
    # te juz zajete.
    do {
	++$self->{nastepny_ruch}
    } while $self->{nastepny_ruch} <= 8
	&& $self->{plansza}[$self->{nastepny_ruch}] ne $pusty;

    $self->{nastepny_ruch} = undef if $self->{nastepny_ruch} == 9;
    return $self->{nastepny_ruch};
}

# Tworzymy nowa pozycje powstala po tym ruchu.
sub wykonaj_ruch {
    my $self = shift;
    my $ruch = shift;

    # Kopiujemy biezaca plansze, zmieniajac tylko pole zajete w ruchu.
    my $mojatura = $self->{tura};
    my $nowaplansza = [ @{$self->{plansza}} ];
    $nowaplansza->[$ruch] = $ruch[$mojatura];

    return kolko_i_krzyzyk->new(1 - $mojatura, $nowaplansza);
}

# Pobierz zapamietana ocene tej pozycji.
sub oceniaj {
    my $self = shift;

    return $self->{wynik};
}

# Wyswietl pozycje.
sub opis {
    my $self = shift;
    my $plansza = $self->{plansza};
    my $desc = "@$plansza[0..2]\n@$plansza[3..5]\n@$plansza[6..8]\n";
    return $desc;
}

sub najlepszy_wynik {
    return 101;
}

1;
