#!/usr/bin/perl

# Patrz tez procedura przeszukiwanie_binarne() z Rozdzialu 1.

# $indeks = binarny_lancuch( \@tablica, $szukany )
#        @tablica zawiera posortowane lancuchy
#    na koniec,
#        albo (jesli element byl w tablicy):
#           # $indeks jest elementem
#           $tablica[$indeks] eq $szukany
#        lub (jesli elementu nie bylo w tablicy):
#           # $indeks jest pozycja, gdzie element nalezy wstawic
#           $indeks == @tablica or $tablica[$indeks] gt $szukany
#           splice( @tablica, $indeks, 0, $szukany ) wstawi go 
#               na miejsce niezaleznie od przypadku
#
sub binarny_lancuch {
     my ($tablica, $szukany) = @_;

     # $pocz jest pierwszym elementem, ktory nie jest za maly;
     # $koniec jest pierwszym elementem, ktory nie jest za duzy
     #
     my ( $pocz, $koniec ) = ( 0, scalar(@$tablica) );

     # Sprawdzaj tak dlugo, jak dlugo moga byc pasujace elementy.
     #
     while ( $pocz < $koniec ) {
         # Sprawdzamy srodkowy element.

         use integer;
         my $biez = ($pocz+$koniec)/2;
         if ($tablica->[$biez] lt $szukany) {
	     $pocz  = $biez + 1;                     # za maly, sprawdz wyzszy
	 } else {
	     $koniec = $biez;                         # nie za maly, sprawdz nizszy
	 } 
     }
     return $pocz;
}

# ($indeks_pocz, $indeks_koniec) =
#   binarny_zakres_lancuch( \@tablica, $szukany_pocz, $szukany_koniec );
#      @tablica jest posortowanymi lancuchami
#      Przy zwracaniu:
#         $tablica[$indeks_pocz..$indeks_koniec] zawiera wszystkie
#           wartosci miedzy $szukany_pocz i $szukany_koniec wlaczajac
#           je (jesli nie ma takich wartosci, to $indeks_pocz bedzie
#           rowny $indeks_koniec+1, a $indeks_pocz bedzie wskazywal
#           pozycje w tablicy @tablica, gdzie taka wartosc ma byc 
#           wstawiona, np., kazda wartosc z zakresu powinna zostac
#           wstawiona tuz przed elementem $indeks_pocz

sub binarny_zakres_lancuch {
    my ($tablica, $szukany_pocz, $szukany_koniec) = @_;
    my $indeks_pocz  = binarny_lancuch( $tablica, $szukany_pocz );
    my $indeks_koniec = binarny_lancuch( $tablica, $szukany_koniec );

    --$indeks_koniec
        if $indeks_koniec == @$tablica ||
                            $tablica->[$indeks_koniec] gt $szukany_koniec;

    return ($indeks_pocz,$indeks_koniec);
}

@rok = qw(0101 0115 0131 0201 0215 0228 0301 0315 0331);

($Sty_start, $Sty_koniec) = binarny_zakres_lancuch(\@rok, '0201', '0229');

# Wyswietla 3, 5

print "$Sty_start, $Sty_koniec\n";
