#!/usr/bin/perl

# Zobacz tez http://www.plover.com/~mjd/perl/BTree/, Mark-Jason Dominus'
# artykul in The Perl Journal #7.

# Wymaga modulu BTree module, BTree.pm, ktory mozna sciagnac spod
# spomnianego adresu URL, oraz spod http://tpj.com/tpj/programs lub
# jako ch04.{tar.gz,zip} spod http://orwant.www.media.mit.edu/algorithms-examples.
#
use BTree;  

my $drzewo = BTree->new( B => 20 );

# Wstawiamy pare elementow.

%hash = (kolor => "czerwony", nazwa => "jablko", ogonek => 1);

while ( my ( $klucz, $wartosc ) = each %hash ) {
    $drzewo->B_search(
        Key    => $klucz,
        Data   => $wartosc,
        Insert => 1 );
}

# Sprawdz, czy sa jakies elementy na drzewie.
@test = qw(kolor wysokosc);
foreach ( @test ) {
    defined $drzewo->B_search( Key => $_ )
        ? print "$_ jest na drzewie.\n"	
        : print "$_ nie ma na drzewie.\n";
}

# Aktualizuj, jesli isnieje, jesli nie, nie rob nic.
$drzewo->B_search(
    Key     => 'jakis klucz',
    Data    => 'nowa wartosc',
    Replace => 1 );

# Utworz lub aktualizuj, niezaleznie, czy istnieje, czy nie.
print $drzewo->B_search(
		      Key     => 'inny klucz',
		      Data    => 'wartosc',
		      Insert  => 1,
		      Replace => 1 ), "\n";


