use Benchmark;

srand; # Randomizacja.
       # UWAGA: dla Perla < 5.004 
       # lepiej uzyc: srand(time + $$ + ($$ << 15)) 

# Tworzymy tablice losowych danych wejsciowych.
@tablica = reverse 'aaa'..'zaz';

# Mutowanie tablicy @tablica.
for ( @tablica ) {
     if (rand() < 0.5) {   # Losowo wstawiamy wielkie litery.
         $_ = ucfirst;
     }
     if (rand() < 0.25) {  # Losowo wstawiamy podkreslenia.
         substr($_, rand(length), 0)= '_';
     }
     if (rand() < 0.333) { # Losowo podwajamy.
         $_ .= $_;
     }
     if (rand() < 0.333) { # Losowo tworymy lustrzane odbicia.
         $_ .= reverse $_;
     }
     if (rand() > 1/length) { # Losowo usuwamy znaki.
         substr($_, rand(length), rand(length)) = '';
     }
}

# funkcja timethese() jest z modulu Benchmark.

timethese(10, {
    'ST' =>
    '@posortowane =
        map { $_->[0] }
            sort { $a->[1] cmp $b->[1] }
                map { # Przerabianie na porzadek slownikowy.
                  my $d = lc;
                  $d =~ s/[\W_]+//g;
                  [ $_, $d ]
                }
                @tablica',
   'bezST' =>
   '@posortowane =
       sort { my ($da, $db) = ( lc( $a ), lc( $b ) );
              $da =~ s/[\W_]+//g;
              $db =~ s/[\W_]+//g;
              $da cmp $db;
            }
            @tablica'
    });
