#!/usr/bin/perl 

# Modul mozna pobrac (oraz potrzebny mu modul Bit::Vector) 
# z sieci CPAN, http://www.perl.com/CPAN/modules/by-module.
use Set::IntRange;

# Tworzymy przedzial liczb calkowitych. Granice moga byc mniejsze.
# od zera. Jedyny warunek, to aby dolna granica (pierwszy argument)
# byla mniejsza niz gorna granica (drugi argument).

$zakres = new Set::IntRange(1, 1000);

# Wlacz bity (elementy) od 100 do 200 (wlacznie).

$zakres->Interval_Fill( 100,200 );

# Wylacz bit 123, wlacz bit 345, i przelacz bit 456.

$zakres->Bit_Off ( 123 );
$zakres->Bit_On  ( 345 );
$zakres->bit_flip( 456 );

# Testuj bit 123.

print "bit 123 jest ", $zakres->bit_test( 123 ) ? "wlaczony" : "wylaczony", "\n";

# Testowanie bitu 9999 uruchamia blad, poniewaz zakres konczy sie na 1000.
# print "bit 9999 jest wlaczony\n" if $zakres->bit_test( 9999 );

# Zwracamy zakres liczb calkowitych w formacie tekstowym.
# Ten format przypomina format stosowany w module Set::IntSpan;
# jednak zamiast '-' w definiowanych zakresach uzywana jest notacja
# '..' Perla. Modul Set::IntRange potrafi rowniez dekodowac i ten
# format, uzywajac metody from_Hex().
#

print $zakres->to_Hex, "\n";
