import matplotlib.pyplot as plt
import numpy as np

from sklearn.datasets import fetch_mldata
from sklearn.decomposition import FastICA

# Wyznacza ziarno losowe w celu odtworzenia rezultatów
np.random.seed(1000)


def zero_center(Xd):
    return Xd - np.mean(Xd, axis=0)


if __name__ == '__main__':
    # Wczytuje zestaw danych
    digits = fetch_mldata('MNIST original')
    X = zero_center(digits['data'].astype(np.float64))
    np.random.shuffle(X)

    # Przeprowadza szybki algorytm ICA za pomocą 64 składowych
    fastica = FastICA(n_components=64, max_iter=5000, random_state=1000)
    fastica.fit(X)

    # Tworzy wykres składowych niezależnych
    fig, ax = plt.subplots(8, 8, figsize=(11, 11))

    for i in range(8):
        for j in range(8):
            ax[i, j].imshow(fastica.components_[(i * 8) + j].reshape((28, 28)), cmap='gray')
            ax[i, j].axis('off')

    plt.show()

    # Przeprowadza szybki algorytm ICA za pomocą 640 składowych
    fastica = FastICA(n_components=640, max_iter=5000, random_state=1000)
    fastica.fit(X)

    # Tworzy wykres składowych niezależnych
    fig, ax = plt.subplots(10, 10, figsize=(11, 11))

    for i in range(10):
        for j in range(10):
            ax[i, j].imshow(fastica.components_[(i * 10) + j].reshape((28, 28)), cmap='gray')
            ax[i, j].axis('off')

    plt.show()

