import matplotlib.pyplot as plt
import numpy as np

from sklearn.covariance import LedoitWolf
from sklearn.datasets import fetch_mldata
from sklearn.decomposition import FactorAnalysis

# Wyznacza ziarno losowe w celu odtworzenia rezultatów
np.random.seed(1000)


def zero_center(Xd):
    return Xd - np.mean(Xd, axis=0)


if __name__ == '__main__':
    # Wczytuje zestaw danych
    digits = fetch_mldata('MNIST original')
    X = zero_center(digits['data'].astype(np.float64))
    np.random.shuffle(X)

    # Tworzy zestaw danych + szum heteroskedastyczny
    Omega = np.random.uniform(0.0, 0.75, size=X.shape[1])
    Xh = X + np.random.normal(0.0, Omega, size=X.shape)

    # Wyświetla zestaw danych + szum heteroskedastyczny
    fig, ax = plt.subplots(10, 10, figsize=(10, 10))

    for i in range(10):
        for j in range(10):
            ax[i, j].imshow(Xh[(i * 10) + j].reshape((28, 28)), cmap='gray')
            ax[i, j].axis('off')

    plt.show()

    # Przeprowadza analizę czynnikową
    fa = FactorAnalysis(n_components=64, random_state=1000)
    fah = FactorAnalysis(n_components=64, random_state=1000)

    Xfa = fa.fit_transform(X)
    Xfah = fah.fit_transform(Xh)

    print('Wynik X analizy czynnikowej: {}'.format(fa.score(X)))
    print('Wynik Xh analizy czynnikowej: {}'.format(fah.score(Xh)))

    # Przeprowadza kurczenie Ledoita-Wolfa
    ldw = LedoitWolf()
    ldwh = LedoitWolf()

    ldw.fit(X)
    ldwh.fit(Xh)

    print('Wynik X Ledoita-Wolfa: {}'.format(ldw.score(X)))
    print('Wynik Xh Ledoita-Wolfa: {}'.format(ldwh.score(Xh)))

    # Wyświetla składowe
    fig, ax = plt.subplots(8, 8, figsize=(10, 10))

    for i in range(8):
        for j in range(8):
            ax[i, j].imshow(fah.components_[(i * 8) + j].reshape((28, 28)), cmap='gray')
            ax[i, j].axis('off')

    plt.show()
