# -*- kodowanie: utf-8 -*-
import numpy as np

# Wyznacza ziarno losowe w celu odtworzenia rezultatów
np.random.seed(1000)


if __name__ == '__main__':
    # Definiuje wektory początkowe
    w = np.array([1.0, 0.2])
    x = np.array([0.1, 0.5])
    alpha = 0.0

    print('Początkowy wektor w: {}'.format(w))

    # Wykonuje przebiegi
    for i in range(50):
        y = np.dot(w, x.T)
        w += x * y
        alpha = np.arccos(np.dot(w, x.T) / (np.linalg.norm(w) * np.linalg.norm(x)))

    print('Końcowy wektor w: {}'.format(w))
    print('Końcowy parametr alpha: {}'.format(alpha * 180.0 / np.pi))

    # Powtarza test dla parametru alpha większego od 90°
    w = np.array([1.0, -1.0])

    print('Początkowy wektor w: {}'.format(w))

    # Wykonuje przebiegi
    for i in range(50):
        y = np.dot(w, x.T)
        w += x * y
        alpha = np.arccos(np.dot(w, x.T) / (np.linalg.norm(w) * np.linalg.norm(x)))

    print('Końcowy wektor w: {}'.format(w))
    print('Końcowy parametr alpha: {}'.format(alpha * 180.0 / np.pi))