import numpy as np

from hmmlearn import hmm

# Wyznacza ziarno losowe w celu odtworzenia rezultatów
np.random.seed(1000)


if __name__ == '__main__':
    # Tworzy wielomianowy model HMM
    hmm_model = hmm.MultinomialHMM(n_components=2, n_iter=100, random_state=1000)

    # Definiuje listę obserwacji
    observations = np.array([[0], [1], [1], [0], [1], [1], [1], [0], [1],
                             [0], [0], [0], [1], [0], [1], [1], [0], [1],
                             [0], [0], [1], [0], [1], [0], [0], [0], [1],
                             [0], [1], [0], [1], [0], [0], [0], [0], [0]], dtype=np.int32)

    # Dopasowuje model za pomocą algorytmu wnioskowania w przód-wstecz
    hmm_model.fit(observations)

    # Sprawdza zbieżność
    print('Uzyskało zbieżność: {}'.format(hmm_model.monitor_.converged))

    # Wyświetla macierz prawdopodobieństwa przejścia
    print('\nMacierz prawdopodobieństwa przejścia:')
    print(hmm_model.transmat_)

    # Tworzy sekwencję testową
    sequence = np.array([[1], [1], [1], [0], [1], [1], [1], [0], [1],
                         [0], [1], [0], [1], [0], [1], [1], [0], [1],
                         [1], [0], [1], [0], [1], [0], [1], [0], [1],
                         [1], [1], [0], [0], [1], [1], [0], [1], [1]], dtype=np.int32)

    # Wyszukuje najbardziej prawdopodobne stany ukryte za pomocą algorytmu Viterbiego
    lp, hs = hmm_model.decode(sequence)

    print('\nNajbardziej prawdopodobne sekwencja stanów ukrytych:')
    print(hs)

    print('\nLogarytm prawdopodobieństwa:')
    print(lp)

    # Oblicza prawdopodobieństwa końcowe
    pp = hmm_model.predict_proba(sequence)

    print('\nPrawdopodobieństwa końcowe:')
    print(pp)
