import matplotlib.pyplot as plt
import numpy as np

from sklearn.datasets import load_wine
from sklearn.decomposition import PCA, FactorAnalysis
from sklearn.ensemble import AdaBoostClassifier
from sklearn.model_selection import cross_val_score


# Wyznacza ziarno losowe w celu odtworzenia rezultatów
np.random.seed(1000)


if __name__ == '__main__':
    # Wczytuje zestaw danych 
    X, Y = load_wine(return_X_y=True)

    # Oblicza wyniki sprawdzianu krzyżowego dla różnej liczby estymatorów
    scores_ne = []

    for ne in range(10, 201, 10):
        adc = AdaBoostClassifier(n_estimators=ne, learning_rate=0.8, random_state=1000)
        scores_ne.append(np.mean(cross_val_score(adc, X, Y, cv=10)))

    # Tworzy wykres wyników sprawdzianu krzyżowego
    fig, ax = plt.subplots(figsize=(15, 7))

    ax.plot(list(range(10, 201, 10)), scores_ne)
    ax.set_xlabel('Liczba estymatorów')
    ax.set_ylabel('Dokładność 10-krotnego sprawdzianu krzyżowego')
    ax.grid()
    plt.show()

    # Oblicza wyniki sprawdzianu krzyżowego dla różnych wartości współczynnika uczenia
    scores_eta_adc = []

    for eta in np.linspace(0.01, 1.0, 100):
        adc = AdaBoostClassifier(n_estimators=50, learning_rate=eta, random_state=1000)
        scores_eta_adc.append(np.mean(cross_val_score(adc, X, Y, cv=10)))

    # Tworzy wykres wyników sprawdzianu krzyżowego
    fig, ax = plt.subplots(figsize=(15, 8))

    ax.plot(list(np.linspace(0.01, 1.0, 100)), scores_eta_adc)
    ax.set_xlabel('Współczynnik uczenia')
    ax.set_ylabel('Dokładność 10-krotnego sprawdzianu krzyżowego')
    ax.grid()
    plt.show()

    # Przeprowadza analizę PCA i analizę czynnikową
    scores_pca = []

    for i in range(13, 1, -1):
        if i < 12:
            pca = PCA(n_components=i, random_state=1000)
            X_pca = pca.fit_transform(X)
        else:
            X_pca = X

        adc = AdaBoostClassifier(n_estimators=50, learning_rate=0.8, random_state=1000)
        scores_pca.append(np.mean(cross_val_score(adc, X_pca, Y, cv=10)))

    scores_fa = []

    for i in range(13, 1, -1):
        if i < 12:
            fa = FactorAnalysis(n_components=i, random_state=1000)
            X_fa = fa.fit_transform(X)
        else:
            X_fa = X

        adc = AdaBoostClassifier(n_estimators=50, learning_rate=0.8, random_state=1000)
        scores_fa.append(np.mean(cross_val_score(adc, X_fa, Y, cv=10)))

    # Tworzy wykres wynikowy
    fig, ax = plt.subplots(figsize=(15, 8))

    ax.plot([i for i in range(2, X.shape[1] + 1)], scores_fa[::-1], label='Analiza czynnikowa')
    ax.plot([i for i in range(2, X.shape[1] + 1)], scores_pca[::-1], label='Analiza PCA')
    ax.set_xlabel('Liczba składowych')
    ax.set_ylabel('Dokładność 10-krotnego sprawdzianu krzyżowego')
    ax.legend()
    ax.grid()
    plt.show()