import numpy as np

from sklearn.datasets import load_digits
from sklearn.model_selection import cross_val_score, LeaveOneOut

from sklearn.svm import SVC


# Wyznacza ziarno losowe w celu odtworzenia rezultatów
np.random.seed(1000)


if __name__ == '__main__':
    # Wczytuje zestaw danych
    data = load_digits()

    # Tworzy wielomianową maszynę wektorów nośnych
    svm = SVC(kernel='poly')

    # Przeprowadza k-krotny sprawdzian krzyżowy
    skf_scores = cross_val_score(svm, data['data'], data['target'], cv=10)
    print('Wyniki sprawdzianu krzyżowego: {}'.format(skf_scores))
    print('Uśredniony wynik sprawdzianu krzyżowego: {}'.format(skf_scores.mean()))

    # Wykonuje sprawdzian krzyżowy metodą Leave-One-Out
    loo_scores = cross_val_score(svm, data['data'], data['target'], cv=LeaveOneOut())
    print('Wyniki metody LOO (100): {}'.format(loo_scores[0:100]))
    print('Uśredniony wynik metody LOO: {}'.format(loo_scores.mean()))