# Rozdział 9. Sztuczne sieci neuronowe
Sztuczne sieci neuronowe są wartościowym elementem w przyborniku narzędzi z dziedziny uczenia maszynowego. Są używane w różny 
sposób do wykonywania zadań takich jak rozpoznawanie obrazu, przetwarzanie języka naturalnego i gra w gry. Sieci ANN uczą się 
w podobny sposób jak inne algorytmy uczenia maszynowego — na podstawie danych treningowych. Najlepiej nadają się do danych 
nieustrukturyzowanych, gdzie trudno jest zrozumieć powiązania między cechami.

## Propagacja w przód
Ogólny proces propagacji w przód obejmuje następujące kroki:
1.	Wprowadzanie obserwacji. Należy podać jedną obserwację ze zbioru danych, dla której chcesz uzyskać prognozę klasy.
2.	Mnożenie danych wejściowych i wag. Należy pomnożyć wszystkie dane wejściowe przez każdą wagę przypisaną połączeniom z węzłami ukrytymi.
3.	Sumowanie ważonych wyników dla każdego węzła ukrytego. Trzeba zsumować ważone dane wejściowe.
4.	Obliczenie funkcji aktywacji dla każdego węzła ukrytego. Należy zastosować funkcję aktywacji do zsumowanych ważonych danych wejściowych.
5.	Sumowanie ważonych danych wyjściowych z węzłów ukrytych i przekazywanie sumy do węzła wyjściowego. Trzeba zsumować ważone wyniki funkcji aktywacji z wszystkich węzłów ukrytych.
6.	Obliczenie funkcji aktywacji dla węzła wyjściowego. Należy zastosować funkcję aktywacji do sumy ważonych wyników z węzłów ukrytych.

## Propagacja wsteczna
1.	Zdefiniuj architekturę sieci ANN. Ten krok wymaga zdefiniowania węzłów wejściowych, węzłów wyjściowych, liczby warstw ukrytych, liczby neuronów w każdej warstwie ukrytej, używanej funkcji aktywacji itd.
2.	Zainicjuj wagi w sieci ANN. Wagi w sieci ANN trzeba zainicjować jakąś wartością. Można zastosować tu różne podejścia. Najważniejszą zasadą jest stałe dostosowywanie wag wraz z uczeniem się sieci ANN na podstawie obserwacji treningowych.
Etap B. Propagacja w przód
Ten proces przebiega tak samo jak przy samym korzystaniu z sieci. Wykonywane są te same obliczenia. Jednak w trakcie uczenia sieci 
prognozowane dane wyjściowe są porównywane z rzeczywistą klasą każdej obserwacji ze zbioru treningowego.
Etap C. Uczenie
1.	Oblicz koszt. Po propagacji w przód jako koszt przyjmowana jest różnica między prognozowanymi danymi wyjściowymi a rzeczywistą klasą obserwacji ze zbioru treningowego. Koszt określa, jak dobrze sieć ANN radzi sobie z prognozowaniem klas obserwacji.
2.	Zaktualizuj wagi w sieci ANN. Wagi w sieci ANN to jedyne wartości, jakie mogą być aktualizowane przez samą sieć. Architektura i konfiguracja zdefiniowane na etapie A nie zmieniają się w procesie uczenia sieci. Wagi kodują inteligencję sieci i mogą być zwiększane lub zmniejszane, co wpływa na „siłę” danych wejściowych. 
3.	Zdefiniuj warunek zakończenia pracy. Proces uczenia nie może trwać w nieskończoność. Podobnie jak w wielu innych algorytmach 
omawianych w tej książce trzeba ustalić sensowny warunek zakończenia pracy. Jeśli zbiór danych jest duży, możesz zdecydować, że w 
procesie uczenia sieci ANN użyjesz 500 obserwacji ze zbioru treningowego i przeprowadzisz 1000 iteracji. Oznacza to, że 500 obserwacji zostanie 1000 razy przekazanych do sieci, a po każdej iteracji algorytm dostosuje wagi.