import matplotlib.pyplot as plt
from sklearn import metrics
from sklearn import linear_model
import sys
sys.path.append('../')
from ml_data_preparation import Data

# Kodowanie tekstowych wartości cech "szlif", "barwa" i "czystość" jako wartości całkowitoliczbowych.
encoding_categories = {'szlif': {'Zadowalający': 1, 'Dobry': 1, 'Bardzo dobry': 2, 'Premium': 2, 'Doskonały': 2},
                       'barwa': {'D': 7, 'E': 6, 'F': 5, 'G': 4, 'H': 3, 'I': 2, 'J': 1},
                       'czystość': {'FL': 11, 'IF': 10, 'VVS1': 9, 'VVS2': 8, 'VS1': 7, 'VS2': 6, 'SI1': 5, 'SI2': 4, 'I1': 3, 'I2': 2, 'I3': 1}}


# Wczytywanie danych z pliku do ramki danych.
data = Data('../diamonds.csv', ['numer'], 'czystość', encoding_categories)
# Inicjowanie modelu regresji liniowej.
regression = linear_model.LinearRegression()
# Filtrowanie danych treningowych (karaty i cena) używanych w regresji liniowej.
regression_train_x = data.X_train['cena'].values[:-1]
regression_train_y = data.X_train['karaty'].values[:-1]
# Dopasowywanie modelu do danych.
regression = regression.fit(regression_train_x.reshape(-1, 1), regression_train_y.reshape(-1, 1))

# Filtrowanie danych testowych (karaty i cena) używanych w regresji liniowej.
reg_test_x = data.X_test['cena'].values[:]
reg_test_y = data.X_test['karaty'].values[:]
# Generowanie prognoz na podstawie wyuczonego modelu regresji liniowej.
prediction_y = regression.predict(reg_test_x.reshape(-1, 1))
prediction_y = prediction_y.reshape(-1, 1)
# Wyświetlanie współczynników.
print('Współczynniki: \n', regression.coef_)
# Wyświetlanie błędu średniokwadratowego.
print('Błąd średniokwadratowy: ', metrics.mean_squared_error(reg_test_y, prediction_y))
# Wyświetlanie wariancji; 1 oznacza idealne predykcje.
print('Wariancja: ', metrics.r2_score(reg_test_y, prediction_y))

# Wyświetlanie danych testowych i prognoz.
plt.scatter(reg_test_x, reg_test_y,  color='black')
plt.plot(reg_test_x, prediction_y, color='red', linewidth=3)
plt.show()
