import maze_puzzle as mp


# Funkcja znajdująca trasę za pomocą algorytmu A*.

# Algorytm A* zwykle poprawia wydajność dzięki heurystyce minimalizowania kosztu następnego odwiedzanego węzła.
# Łączny koszt jest obliczany na podstawie dwóch cech: łącznej odległości od węzła początkowego do danego i 
# szacowanego kosztu przejścia do danego węzła za pomocą heurystyki. Gdy chcesz zminimalizować koszt, niższa 
# wartość oznacza wydajniejsze rozwiązanie
def run_astar(maze_game, current_point):
    # Umieszczanie bieżącego węzła na stosie
    visited_points = []
    stack = [current_point]
    # Przeszukiwanie jest kontynuowane, dopóki na stosie znajdują się węzły
    while stack:
        # Ustawianie następnego węzła ze stosu jako bieżącego
        next_point = stack.pop()
        # Jeśli bieżący węzeł nie został jeszcze sprawdzony, należy to zrobić
        if not is_in_visited_points(next_point, visited_points):
            visited_points.append(next_point)
            # Zwracanie ścieżki do bieżącego sąsiada, jeśli jest on węzłem docelowym
            if maze_game.get_current_point_value(next_point) == '*':
                return next_point
            else:
                # Umieszczanie na stosie wszystkich sąsiadów bieżącego węzła
                neighbors = maze_game.get_neighbors(next_point)
                for neighbor in neighbors:
                    neighbor.set_parent(next_point)
                    neighbor.cost = determine_cost(next_point, neighbor)
                stack.extend(neighbors)
                stack.sort(key=lambda x: x.cost, reverse=True)
    return "Nie istnieje ścieżka do węzła docelowego"


# Określanie kosztu na podstawie odległości do korzenia
def determine_cost(origin, target):
    distance_to_root = mp.get_path_length(target)
    cost = mp.get_move_cost(origin, target)
    return distance_to_root + cost


# Funkcja sprawdzająca, czy dany punkt został już odwiedzony
def is_in_visited_points(current_point, visited_points):
    for visited_point in visited_points:
        if current_point.x == visited_point.x and current_point.y == visited_point.y:
            return True
    return False


print('--- Algorytm A* ---')

# Inicjowanie labiryntu
maze_game_main = mp.MazePuzzle()

# Uruchamianie zachłannego algorytmu przeszukiwania dla zainicjowanego labiryntu
outcome = run_astar(maze_game_main, mp.Point(2, 2))

# Pobieranie ścieżki znalezionej przez zachłanny algorytm przeszukiwania
astar_path = mp.get_path(outcome)

# Wyświetlanie informacji o znalezionej ścieżce
print('DŁUGOŚĆ ŚCIEŻKI: ', mp.get_path_length(outcome))
maze_game_main.overlay_points_on_map(astar_path)
print('KOSZT ŚCIEŻKI: ', mp.get_path_cost(outcome))
for point in astar_path:
    print('Punkt: ', point.x, ',', point.y)
