import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns

# Wczytywanie pliku do ramki danych.
data = pd.read_csv("diamonds.csv")
print(data.describe())
print(data.dtypes)

# Definiowanie analizowanych cech.
feature_x = 'karaty'
feature_y = 'cena'

# Filtrowanie danych na podstawie cechy "szlif".
fair_diamonds = data[data['szlif'] == "Fair"]
good_diamonds = data[data['szlif'] == "Good"]
very_good_diamonds = data[data['szlif'] == "Very Good"]
premium_diamonds = data[data['szlif'] == "Premium"]
ideal_diamonds = data[data['szlif'] == "Ideal"]

# Wyświetlanie przefiltrowanych danych jako wykresu punktowego.
fig = plt.figure()
plt.title(feature_x + ' i ' + feature_y)

plt.scatter(fair_diamonds[feature_x], fair_diamonds[feature_y], label="Fair", s=1.8)
plt.scatter(good_diamonds[feature_x], good_diamonds[feature_y], label="Good", s=1.8)
plt.scatter(very_good_diamonds[feature_x], very_good_diamonds[feature_y], label="Very Good", s=1.8)
plt.scatter(premium_diamonds[feature_x], premium_diamonds[feature_y], label="Premium", s=1.8)
plt.scatter(ideal_diamonds[feature_x], ideal_diamonds[feature_y], label="Ideal", s=1.8)

plt.legend(bbox_to_anchor=(1.05, 1), loc=2, borderaxespad=0.)
plt.xlabel(feature_x)
plt.ylabel(feature_y)
plt.show()


# Kodowanie wartości tekstowych dla cech "szlif", "barwa" i "czystość" jako wartości całkowitoliczbowych.
encoding_categories = {'szlif': {'Fair': 1, 'Good': 2, 'Very Good': 3, 'Premium': 4, 'Ideal': 5},
                       'barwa': {'D': 7, 'E': 6, 'F': 5, 'G': 4, 'H': 3, 'I': 2, 'J': 1},
                       'czystość': {'FL': 11, 'IF': 10, 'VVS1': 9, 'VVS2': 8, 'VS1': 7, 'VS2': 6, 'SI1': 5, 'SI2': 4, 'I1': 3, 'I2': 2, 'I3': 1}}

data.replace(encoding_categories, inplace=True)

# Wyświetlanie przefiltrowanych danych jako mapy cieplnej opartej na cechach "szlif", "barwa" i "czystość".
data_subset = data[['karaty', 'szlif', 'barwa', 'czystość', 'głębokość', 'tafla', 'cena', 'wymiar x', 'wymiar y', 'wymiar z']]
cor = data_subset.corr()
sns.heatmap(cor, square=True)
plt.show()
