import itertools
from itertools import product
import time

# Indeksy tablicy z danymi.
# 0 = nazwa, 1 = waga, 2 = wartość, 3 = przystosowanie
KNAPSACK_WEIGHT_INDEX = 1
KNAPSACK_VALUE_INDEX = 2
KNAPSACK_FITNESS_INDEX = 3

# Mały zbiór danych do problemu plecakowego.
knapsack_items = [
    ['Perły', 3, 4],
    ['Złoto', 7, 7],
    ['Korona', 4, 5],
    ['Moneta', 1, 1],
    ['Topór', 5, 4],
    ['Miecz', 4, 3],
    ['Pierścień', 2, 5],
    ['Puchar', 3, 1],
]

# Duży zbiór danych do problemu plecakowego.
# knapsack_items = [
#     ['Topór', 32252, 68674],
#     ['Moneta z brązu', 225790, 471010],
#     ['Korona', 468164, 944620],
#     ['Diamentowy posążek', 489494, 962094],
#     ['Szmaragdowy pas', 35384, 78344],
#     ['Skamieliny', 265590, 579152],
#     ['Złota moneta', 497911, 902698],
#     ['Hełm', 800493, 1686515],
#     ['Tusz', 823576, 1688691],
#     ['Szkatułka', 552202, 1056157],
#     ['Nóż', 323618, 677562],
#     ['Długi miecz', 382846, 833132],
#     ['Maska', 44676, 99192],
#     ['Naszyjnik', 169738, 376418],
#     ['Opalowa zawieszka', 610876, 1253986],
#     ['Perły', 854190, 1853562],
#     ['Kołczan', 671123, 1320297],
#     ['Rubinowy pierścień', 698180, 1301637],
#     ['Srebrna bransoleta', 446517, 859835],
#     ['Czasomierz', 909620, 1677534],
#     ['Mundur', 904818, 1910501],
#     ['Trucizna', 730061, 1528646],
#     ['Wełniany szal', 931932, 1827477],
#     ['Kusza', 952360, 2068204],
#     ['Stara księga', 926023, 1746556],
#     ['Puchar z cynku', 978724, 2100851, 0]
# ]


# Tworzenie wszystkich możliwych kombinacji przedmiotów. Jest to przeszukiwanie kompletne,
# które jest kosztowne obliczeniowo!
def get_all_combinations(items):
    combinations = []
    for index in range(0, len(items)):
        combinations.append(items[index])
        possibilities = [list(x) for x in itertools.combinations(items, index)]
        combinations.append(possibilities)
    return combinations


# Obliczanie przystosowania dla wybranych przedmiotów i maksymalnej wagi.
def calculate_individual_fitness(solution, maximum_weight):
    total_weight = 0
    total_value = 0
    # Pobieranie wartości i wagi każdego przedmiotu z oznaczeniem 1.
    for item_index in range(0, len(solution)):
        item = solution[item_index]
        if item == 1:
            total_weight += knapsack_items[item_index][KNAPSACK_WEIGHT_INDEX]
            total_value += knapsack_items[item_index][KNAPSACK_VALUE_INDEX]
    # Zerowe przystosowanie, jeśli waga jest przekroczona.
    if total_weight > maximum_weight:
        return 0
    return total_value


# Uruchamianie algorytmu siłowego.
def run_brute_force():
    bit_string_size = 8
    best_score = 0
    best_individual = []
    knapsack_max_capacity = 10
    print('Liczba kombinacji: ', 2**bit_string_size)
    iteration = 0
    for i in product([0, 1], repeat=bit_string_size):
        current = calculate_individual_fitness(i, knapsack_max_capacity)
        if current > best_score:
            best_score = current
            best_individual = i
            print('Iteracja: ', iteration)
            print('Najlepszy wynik: ', best_score)
            print('Najlepszy osobnik: ', best_individual)
        iteration += 1

    print(best_individual)


# Wykonywanie algorytmu siłowego i pomiar czasu pracy.
start_time = time.time()
run_brute_force()
end_time = time.time()
total_time = end_time - start_time
print('Czas w sumie: ', total_time)
